/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.client.controls.chart.impl;

import com.queplix.core.client.app.vo.chart.ChartModel;
import com.queplix.core.client.controls.chart.QChart;
import com.queplix.core.client.controls.chart.QChartViewImpl;

class QwossChart extends QChart {
	
	static final String TICKET_FORM_ID = "eservice__ticket__ticket__ticket.ticket";
	static final String STATUS_FIELD_ID = "qw_status";
	static final long STATUS_CLOSED_VALUE = 10;
	static final String DATEREPORTED_FIELD_ID = "qw_datereported";

	public QwossChart(ChartModel chartModel) {
        model = new QwossChartModelImpl(chartModel);
        view = new QChartViewImpl(model);
        controller = new QwossChartControllerImpl(model, view);
	}

}
