/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.client.controls.chart.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.app.vo.ListboxFieldData;
import com.queplix.core.client.controls.chart.QChartControllerImpl;
import com.queplix.core.client.controls.chart.QChartModel;
import com.queplix.core.client.controls.chart.QChartView;

class QwossChartControllerImpl extends QChartControllerImpl {

	public QwossChartControllerImpl(QChartModel model, QChartView view){
    	super(model, view);
    }

    protected void setFiltersToModel(){
        Map filterMap = getModel().getMeta().getFilters();
        List filters = (List) filterMap.get(QwossChart.TICKET_FORM_ID);
        if(filters == null){
        	filters = new ArrayList();
        	filterMap.put(QwossChart.TICKET_FORM_ID, filters);
        }

        for (Iterator it = filters.iterator(); it.hasNext();) {
			FieldData fieldData = (FieldData) it.next();
			String fieldId = fieldData.getFieldID();
			if(QwossChart.STATUS_FIELD_ID.equals(fieldId) && fieldData instanceof ListboxFieldData){
				ListboxFieldData listBoxData = (ListboxFieldData) fieldData;
				listBoxData.getItemsSelected().setIDSelected(
						QwossChart.STATUS_CLOSED_VALUE, getView().isIncludeClosed());
			}
			// Date range filter will be changed automatically by date filter control
		}

        return;
    }

}
