/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.client.controls.chart.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.queplix.core.client.app.vo.DateFieldData;
import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.app.vo.ListboxFieldData;
import com.queplix.core.client.app.vo.chart.ChartMeta;
import com.queplix.core.client.app.vo.chart.ChartModel;
import com.queplix.core.client.controls.chart.QChartModelImpl;

public class QwossChartModelImpl extends QChartModelImpl {

    /**
     * GWT serialization constructor
     */
    public QwossChartModelImpl() {
    }
    
    public QwossChartModelImpl(ChartMeta meta) {
        super(meta);
    }

    public QwossChartModelImpl(ChartModel model) {
    	super(model);
    }

    public DateFieldData getDateFilter() {
    	List filters = getFilterList();
    	if(filters != null){
    		for (Iterator it = filters.iterator(); it.hasNext();) {
				FieldData fieldData = (FieldData) it.next();
				if(QwossChart.DATEREPORTED_FIELD_ID.equals(fieldData.getFieldID())
						&& fieldData instanceof DateFieldData){
					return (DateFieldData) fieldData;
				}
				
			}
    	}
    	return null;
    }

    public boolean isIncludeClosed() {
    	List filters = getFilterList();
    	if(filters == null)
    		return false;

    	for (Iterator it = filters.iterator(); it.hasNext();) {
			FieldData fieldData = (FieldData) it.next();
			if(QwossChart.STATUS_FIELD_ID.equals(fieldData.getFieldID())
					&& fieldData instanceof ListboxFieldData){

				return ((ListboxFieldData) fieldData).getItemsSelected()
						.isIDSelected(QwossChart.STATUS_CLOSED_VALUE);
			}
			
		}
        return false;
    }

    private List getFilterList(){
    	Map filterMap = getMeta().getFilters();
    	if(filterMap == null)
    		return null;

    	return (List) filterMap.get(QwossChart.TICKET_FORM_ID);
    }
}
