package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.frames.mainframe.DefaultOperationStrategy;
import com.queplix.core.client.frames.mainframe.FormOperations;
import com.queplix.core.client.frames.mainframe.FormState;
import com.queplix.core.client.frames.mainframe.OperationContext;
import com.queplix.core.client.frames.mainframe.OperationTypes;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.app.vo.EntityData;
import com.queplix.core.client.app.vo.FieldMeta;
import com.queplix.core.client.app.vo.GridSearchProperties;
import com.queplix.core.client.app.vo.FieldDataRequest;
import com.queplix.core.client.app.vo.MetaData;

import java.util.ArrayList;
import java.util.Collection;

/**
 * OSS operation strategy implementation.
 * For more details:
 *
 * @author Sergey Savchuk
 * @see com.queplix.core.client.frames.mainframe.DefaultOperationStrategy
 * @since May 8, 2007
 */
public class OSSOperationStrategy extends DefaultOperationStrategy {

    /**
     * Call appropriate OSSOperationStrategy method.
     */
    public static final boolean CONTINUE = true;

    /**
     * Break execution.
     */
    public static final boolean BREAK = false;

    /**
     * Preinitialized fields.
     */
    private FieldData[] initialFieldsData;

    /**
     * List of external filters.
     */
    private ArrayList externalEntityFilters = new ArrayList();

    public void setInitialFieldsData(FieldData[] fieldsData) {
        initialFieldsData = fieldsData;
    }

    public FieldData[] getInitialFieldsData() {
        return initialFieldsData;
    }

    public ArrayList getExternalEntityFilters() {
        return externalEntityFilters;
    }

    public void addExternalFilter(EntityData entityFilter) {
        if (externalEntityFilters != null) {
            externalEntityFilters.add(entityFilter);
        }
    }

    public void removeAllExternalFilters() {
        externalEntityFilters.clear();
    }

    public void searchRecords(Collection entitiesFilters,
                              GridSearchProperties props,
                              boolean isLocalSearch) {
        if (externalEntityFilters != null && externalEntityFilters.size() > 0) {
            if (entitiesFilters != null) {
                entitiesFilters.addAll(externalEntityFilters);
            } else {
                entitiesFilters = externalEntityFilters;
            }
            removeAllExternalFilters();
        }
        super.searchRecords(entitiesFilters, props, isLocalSearch);
    }

    public void handleControlDataRequest(FieldDataRequest request) {
        if (processControlDataRequest(request)) {
            super.handleControlDataRequest(request);
        }
    }

    protected boolean processControlDataRequest(FieldDataRequest request) {
        return CONTINUE;
    }
    
    public void handleLinkEvent(String fromLinkFieldId) {
        FamgMeta.Index formIndex = getFormIndex();
        OperationContext context = getOperationContext();
        FormOperations formContext = context.getFormOperations();
        int state = formContext.getFormState(formIndex);
        switch(state) {
            case FormState.SELECTED_STATE:
                MetaData metadata = context.getMetaData();
                FamgMeta formMeta = metadata.getFamgMeta(formIndex);
                FieldMeta fieldMeta = formMeta.getForm().getEntityMeta().getField(fromLinkFieldId);
                FamgMeta.Index toFormIndex = fieldMeta.getLinkedForm();
                String linkedForm = metadata.getFormID(toFormIndex);
                if(!processFilteredLink(linkedForm, formContext, formIndex))
                    break;
                //clear form
                context.getGridOperations().activateGrid(toFormIndex);
                context.getFormOperations().activateForm(toFormIndex);
                formContext.clearForm(toFormIndex, true);
                //perform search
                getOperationContext().performOperation( OperationTypes.SEARCH_RECORDS, toFormIndex);
                return;
        }
        //surfe to form
        super.handleLinkEvent(fromLinkFieldId);
    }
    
    protected boolean processFilteredLink(String linkedForm, 
            FormOperations formContext, FamgMeta.Index formIndex){
        return BREAK;
    }    
}
