/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.rpc.RPC;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.app.vo.ListboxFieldData;
import com.queplix.core.client.common.ui.DialogHelper;
import com.queplix.core.client.frames.mainframe.DefaultOperationStrategy;
import com.queplix.core.client.frames.mainframe.FormState;
import com.queplix.core.client.frames.mainframe.OperationTypes;
import com.queplix.qwoss.client.app.rpc.CustomRPC;

/**
 * Description:
 *
 * @author Ladnev Ilya
 * @since 06-Mar-2007
 */
final class QTaskHandler extends OSSOperationStrategy {

    private static final String FORM_START_TASK_BUTTON
            = "FORM_START_TASK_BUTTON";
    private static final String FORM_STOP_TASK_BUTTON = "FORM_STOP_TASK_BUTTON";
    private static final String TASK_STATUS_FIELD = "task_status_id";

    private static final int TASK_STATUS_NEW = 0;
    private static final int TASK_STATUS_READY = 1;
    private static final int TASK_STATUS_RUNNING = 2;
    private static final int TASK_STATUS_WAITING = 3;
    private static final int TASK_STATUS_COMPLETED = 4;
    private static final int TASK_STATUS_INTERRUPTED = 5;

    /*public void afterSearchAsync(QForm form, boolean isLocalSearch, boolean success) {
        if(!success) {
            return;
        }
        QFormModel qFormModel = form.getModel();
        if(qFormModel.getFormState() == QFormState.SELECTED_STATE){
            FieldData taskStatus = qFormModel.getElementData(TASK_STATUS_FIELD);
            String[] buttonsId = {FORM_START_TASK_BUTTON, FORM_STOP_TASK_BUTTON};
            if(!taskStatus.isEmpty()){
                long selId = ((ListboxFieldData)taskStatus).getItemsSelected().getSelectedIDs()[0];
                switch((int)selId){
                    case TASK_STATUS_READY:
                    case TASK_STATUS_RUNNING:
                    case TASK_STATUS_WAITING: 
                        // disable START button
                        DialogHelper.showModalMessageDialog("disable START button");
                        buttonsId = new String[1];
                        buttonsId[0] = FORM_START_TASK_BUTTON;
                        form.getView().setCustomButtonsEnabled(buttonsId, false);
                        break;
                    case TASK_STATUS_NEW:
                    case TASK_STATUS_COMPLETED:
                    case TASK_STATUS_INTERRUPTED:
                        // disable STOP button 
                        DialogHelper.showModalMessageDialog("disable STOP button");
                        buttonsId = new String[1];
                        buttonsId[0] = FORM_STOP_TASK_BUTTON;
                        form.getView().setCustomButtonsEnabled(buttonsId, false);
                        break;
                    default: 
                        // disable both 
                        form.getView().setCustomButtonsEnabled(buttonsId, false);
                }
            }
            else{ // enable both
                form.getView().setCustomButtonsEnabled(buttonsId, true);
            }
        }        
    }*/

    private boolean checkStatus(FamgMeta.Index form, String buttonId) {
        FieldData taskStatus = getOperationContext().getFormOperations()
                .getFieldData(
                        form, TASK_STATUS_FIELD);
        if(!taskStatus.isEmpty()) {
            long selId = ((ListboxFieldData) taskStatus).getItemsSelected()
                    .getSelectedIDs()[0];
            switch((int) selId) {
                case TASK_STATUS_READY:
                case TASK_STATUS_RUNNING:
                case TASK_STATUS_WAITING:
                    if(buttonId.equalsIgnoreCase(FORM_STOP_TASK_BUTTON)) {
                        return true;
                    }
                    break;
                case TASK_STATUS_NEW:
                case TASK_STATUS_COMPLETED:
                case TASK_STATUS_INTERRUPTED:
                    if(buttonId.equalsIgnoreCase(FORM_START_TASK_BUTTON)) {
                        return true;
                    }
                    break;
                default:
                    return false;
            }
        }
        return false;
    }

    public void handleCustomButtonEvent(String buttonId) {
        FamgMeta.Index formIndex = getFormIndex();
        if(buttonId.equalsIgnoreCase(FORM_START_TASK_BUTTON)) {
            int state = getOperationContext().getFormOperations().getFormState(
                    formIndex);
            switch(state) {
                case FormState.SELECTED_STATE:
                    if(!checkStatus(formIndex, buttonId)) {
                        DialogHelper.showModalMessageDialog(
                                "This button is available only if task in new, interrupted or completed status.");
                    } else {
                        startTask(formIndex);
                    }
                    break;
                default:
                    DialogHelper.showModalMessageDialog(
                            "This button is available only in SELECTED state.");
            }
        } else if(buttonId.equalsIgnoreCase(FORM_STOP_TASK_BUTTON)) {
            int state = getOperationContext().getFormOperations().getFormState(
                    formIndex);
            switch(state) {
                case FormState.SELECTED_STATE:
                    if(!checkStatus(formIndex, buttonId)) {
                        DialogHelper.showModalMessageDialog(
                                "This button is available only if task in ready, running or waiting status.");
                    } else {
                        stopTask(formIndex);
                    }
                    break;
                default:
                    DialogHelper.showModalMessageDialog(
                            "This button is available only in SELECTED state.");
            }
        }
    }

    public void startTask(FamgMeta.Index form) {
        Long taskId = getOperationContext().getFormOperations()
                .getSelectedRecordId(form);
        RPC.QAsyncCallback callback = new StartTaskAsyncCallback(form);
        CustomRPC.getCustomRPC().startTask(taskId, callback);
    }

    private class StartTaskAsyncCallback extends RPC.QAsyncCallback {
        private FamgMeta.Index form;

        public StartTaskAsyncCallback(FamgMeta.Index form) {
            this.form = form;
        }

        public void onRequestEnded(boolean success, Object result) {
            if(success) {
                getOperationContext().performOperation(
                        OperationTypes.SEARCH_RECORDS, form);
            }
        }
    }

    public void stopTask(FamgMeta.Index form) {
        Long taskId = getOperationContext().getFormOperations()
                .getSelectedRecordId(form);
        RPC.QAsyncCallback callback = new StopTaskAsyncCallback(form);
        CustomRPC.getCustomRPC().stopTask(taskId, callback);
    }

    private class StopTaskAsyncCallback extends RPC.QAsyncCallback {
        private FamgMeta.Index form;

        public StopTaskAsyncCallback(FamgMeta.Index form) {
            this.form = form;
        }

        public void onRequestEnded(boolean success, Object result) {
            if(success) {
                getOperationContext().performOperation(
                        OperationTypes.SEARCH_RECORDS, form);
            }
        }
    }

}
