/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.rpc.RPC;
import com.queplix.core.client.app.vo.EmailComposeRequestObject;
import com.queplix.core.client.frames.email.EmailComposeDialog;
import com.queplix.qwoss.client.app.rpc.CustomRPC;

/**
 * @author Rustem Nizamiev
 */
public class ReplyComposeDialog extends EmailComposeDialog {
    private int objectType;
    private long objectId;

    public ReplyComposeDialog(String caption, boolean isFromEnabled,
                              boolean isSubjectEnabled) {
        super(caption, isFromEnabled, isSubjectEnabled);
    }

    public ReplyComposeDialog(boolean isFromEnabled, boolean isSubjectEnabled) {
        this("Reply Compose Form", isFromEnabled, isSubjectEnabled);
    }

    public ReplyComposeDialog() {
        this(false, false);
    }

    public ReplyComposeDialog(String caption) {
        this(caption, false, false);
    }

    public void performSendEmailAction(EmailComposeRequestObject request,
                                       RPC.QAsyncCallback callback) {
        CustomRPC.getCustomRPC().sendReply(request, objectType, objectId,
                callback);
    }

    public void setObjectType(int objType) {
        objectType = objType;
    }

    public void setObjectId(long objId) {
        objectId = objId;
    }

    public boolean processPlainTextAsHtml() {
        return true;
    }

}