/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.frames.mainframe.BusinessOperationStrategy;
import com.queplix.core.client.frames.mainframe.OperationContext;
import com.queplix.core.client.frames.mainframe.impl.DefaultStrategiesFactory;

/**
 * Description:
 *
 * @author rustem.nizamiev
 * @since 15  2007 ., 20:35
 */
public class StrategiesFactoryQWOss extends DefaultStrategiesFactory {
    private static final String ESERVICE_TICKET_TICKET_TICKET_FORM
            = "eservice__ticket__ticket__ticket.ticket";
    private static final String ESERVICE_INTERACTION_INTERACTION_INTERACTION_FORM
            = "eservice__interaction__interaction__interaction.interaction";
    private static final String ESERVICE_TICKET_TICKETEVENT_TICKETEVENT_FORM
            = "eservice__ticket__ticketevent__ticketevent.ticket";
    private static final String PERMISSION_SECURITY_FORM
            = "admin__security__permissions__permission.security";
    private static final String HISTORY_MANAGEMENT_FORM
            = "admin__history__history_mgmt__historytable.admin";
    private static final String ACCOUNT_MANAGEMENT_FORM
            = "admin__email_management__account__account.admin";

    private static final String EMAIL_FILTER_MANAGEMENT_FORM
            = "admin__email_management__filters__email_filter.admin";
    private static final String EMAIL_ROUTING_RULES_MANAGEMENT_FORM
            = "admin__email_management__routings__email_routing_rules.admin";
    private static final String ATTACHMENT_TICKET_FORM
            = "eservice__ticket__attachment__attachment.eservice";
    private static final String ATTACHMENT_KNOWLEDGE_BASE_FORM
            = "knowledge_base__solution__attachment__attachment.knowledge_base";
    private static final String ATTACHMENT_MYQUEUE_FORM
            = "myqueweb__myqueweb__inbox__attachment.myqueweb";
    private static final String SOLUTION_KNOWLEDGE_BASE_FORM
            = "knowledge_base__solution__solution__solution.knowledge_base";
    private static final String WORKFLOW_MANAGEMENT_FORM
            = "mgmt__workflow__workflow__workflow.management";
    private static final String QTASK_MANAGEMENT_FORM
            = "admin__system__scheduler__tasks.admin";
    private static final String RELEASE_LOCK_FORM
            = "admin__system__lock__lock.admin";
    private static final String MY_QUEUE_FORM
            = "myqueweb__myqueweb__inbox__inbox.myqueweb";

    private boolean initCluster;

    // Application handlers set
    private TicketHandler ticketHandler;
    private TicketEventHandler ticketEventHandler;
    private AttachmentTicketHandler attachTicketHandler;
    private AttachmentSolutionHandler attachSolutionHandler;
    private InteractionHandler interHandler;
    private SolutionHandler solutionHandler;
    private MyQueueHandler myQueueHandler;

    public StrategiesFactoryQWOss(OperationContext opContextIn) {
        super(opContextIn);
    }

    protected Object createObject(String formID) {
        BusinessOperationStrategy ret;
        if(getTicketForm().equalsIgnoreCase(
                formID)) {//formId can be null object.
            initializeCluster();
            ret = ticketHandler;
        } else if(getTicketEventForm().equalsIgnoreCase(formID)) {
            initializeCluster();
            ret = ticketEventHandler;
        } else if(getInteractionForm().equalsIgnoreCase(formID)) {
            initializeCluster();
            ret = interHandler;
        } else if(getPermissionSecurityForm().equalsIgnoreCase(formID)) {
            ret = new PermissionSecurityStrategy();
        } else if(getHistoryManagementForm().equalsIgnoreCase(formID)) {
            ret = new HistoryManagmentHandler();
        } else if(getAccountManagementForm().equalsIgnoreCase(formID)) {
            ret = new AccountHandler();
        } else if(getEmailFilterManagementForm().equalsIgnoreCase(formID)) {
            ret = new EmailFilterHandler();
        } else if(getEmailRoutingRulesManagementForm().equalsIgnoreCase(
                formID)) {
            ret = new EmailRoutRuleHandler();
        } else if(getSolutionForm().equalsIgnoreCase(formID)) {
            initializeCluster();
            ret = solutionHandler;
        } else if(getWorkflowManagementForm().equalsIgnoreCase(formID)) {
            ret = new WorkflowHandler();
        } else if(getQtaskManagementForm().equalsIgnoreCase(formID)) {
            ret = new QTaskHandler();
        } else if(getAttachmentTicketForm().equalsIgnoreCase(formID)) {
            initializeCluster();
            ret = attachTicketHandler;
        } else if(getAttachmentKnowledgeBaseForm().equalsIgnoreCase(formID)) {
            initializeCluster();
            ret = attachSolutionHandler;
        } else if(getAttachmentMyqueueForm().equalsIgnoreCase(formID)) {
            ret = new AttachmentMyQueueHandler();
        } else if(getReleaseLockForm().equalsIgnoreCase(formID)) {
            ret = new ReleaseLockHandler();
        } else if(getMyQueueForm().equalsIgnoreCase(formID)) {
            initializeCluster();
            ret = myQueueHandler;
        } else {
            ret = (BusinessOperationStrategy) super.createObject(formID);
        }
        return ret;
    }

    /**
     * Initialize cluster's handlers.
     */
    protected void initializeCluster() {
        if(!initCluster) {
            ticketHandler = createTicketHandler();
            ticketEventHandler = createTicketEventHandler();
            attachTicketHandler = createAttachTicketHandler();
            interHandler = createInterHandler();
            solutionHandler = createSolutionHandler();
            attachSolutionHandler = createAttachSolutionHandler();
            myQueueHandler = createMyQueueHandler();
            initTicketHandler();
            initAttachTicketHandler();
            initInterHandler();
            initSolutionHandler();
            initAttachSolutionHandler();
            initMyQueueHandler();
            initCluster = true;
        }
    }

    protected TicketHandler createTicketHandler() {
        return new TicketHandler();
    }

    protected TicketEventHandler createTicketEventHandler() {
        return new TicketEventHandler();
    }

    protected AttachmentTicketHandler createAttachTicketHandler() {
        return new AttachmentTicketHandler();
    }

    protected InteractionHandler createInterHandler() {
        return new InteractionHandler();
    }

    protected SolutionHandler createSolutionHandler() {
        return new SolutionHandler();
    }

    protected AttachmentSolutionHandler createAttachSolutionHandler() {
        return new AttachmentSolutionHandler();
    }

    protected MyQueueHandler createMyQueueHandler() {
        return new MyQueueHandler();
    }

    /**
     * Initialize TicketHandler.
     */
    protected void initTicketHandler() {
        ticketHandler.setAttachHandler(attachTicketHandler);
        ticketHandler.setAttachTicketFormId(getAttachmentTicketForm());
        ticketHandler.setTicketEventHandler(ticketEventHandler);
        ticketHandler.setTicketEventFormId(getTicketEventForm());
        ticketHandler.setInterHandler(interHandler);
        ticketHandler.setInterFormId(getInteractionForm());
        ticketHandler.setSolutionHandler(solutionHandler);
        ticketHandler.setSolutionFormId(getSolutionForm());
    }

    /**
     * Initialize AttachmentTicketHandler.
     */
    protected void initAttachTicketHandler() {
        attachTicketHandler.setTicketFormId(getTicketForm());
    }

    /**
     * Initialize InteractionHandler.
     */
    protected void initInterHandler() {
        interHandler.setTicketHandler(ticketHandler);
        interHandler.setTicketFormId(getTicketForm());
    }

    /**
     * Initialize SolutionHandler.
     */
    protected void initSolutionHandler() {
        solutionHandler.setAttachSolutionHandler(attachSolutionHandler);
        solutionHandler.setAttachKnowBaseFormId(
                getAttachmentKnowledgeBaseForm());
        solutionHandler.setTicketHandler(ticketHandler);
        solutionHandler.setTicketFormId(getTicketForm());
    }

    /**
     * Initialize AttachmentSolutionHandler.
     */
    protected void initAttachSolutionHandler() {
        attachSolutionHandler.setSolutionFormId(getSolutionForm());
    }

    /**
     * Initialize InteractionHandler.
     */
    protected void initMyQueueHandler() {
        myQueueHandler.setTicketFormId(getTicketForm());
        myQueueHandler.setInterFormId(getInteractionForm());
    }


    /**
     * Get appropriate form id.
     *
     * @return formID
     */
    protected String getTicketForm() {
        return ESERVICE_TICKET_TICKET_TICKET_FORM;
    }

    protected String getTicketEventForm() {
        return ESERVICE_TICKET_TICKETEVENT_TICKETEVENT_FORM;
    }

    protected String getInteractionForm() {
        return ESERVICE_INTERACTION_INTERACTION_INTERACTION_FORM;
    }

    protected String getPermissionSecurityForm() {
        return PERMISSION_SECURITY_FORM;
    }

    protected String getHistoryManagementForm() {
        return HISTORY_MANAGEMENT_FORM;
    }

    protected String getAccountManagementForm() {
        return ACCOUNT_MANAGEMENT_FORM;
    }

    protected String getEmailFilterManagementForm() {
        return EMAIL_FILTER_MANAGEMENT_FORM;
    }

    protected String getEmailRoutingRulesManagementForm() {
        return EMAIL_ROUTING_RULES_MANAGEMENT_FORM;
    }

    protected String getAttachmentTicketForm() {
        return ATTACHMENT_TICKET_FORM;
    }

    protected String getAttachmentKnowledgeBaseForm() {
        return ATTACHMENT_KNOWLEDGE_BASE_FORM;
    }

    protected String getAttachmentMyqueueForm() {
        return ATTACHMENT_MYQUEUE_FORM;
    }

    protected String getSolutionForm() {
        return SOLUTION_KNOWLEDGE_BASE_FORM;
    }

    protected String getWorkflowManagementForm() {
        return WORKFLOW_MANAGEMENT_FORM;
    }

    protected String getQtaskManagementForm() {
        return QTASK_MANAGEMENT_FORM;
    }

    protected String getReleaseLockForm() {
        return RELEASE_LOCK_FORM;
    }

    protected String getMyQueueForm() {
        return MY_QUEUE_FORM;
    }
}
