<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:strip-space elements="*"/>

	<xsl:template match="/">
		<html>
		<head>
		<link rel="stylesheet" href="/style/main.css" type="text/css"/>
		<script src="/js/modules/focus/gridmenu.js"></script>
		<script>
			<xsl:for-each select="//tab">
				<xsl:text disable-output-escaping="yes">top.Focus.setGridTab(&apos;</xsl:text>
				<xsl:value-of select="@name"/>
				<xsl:text disable-output-escaping="yes">&apos;, &apos;</xsl:text>
				<xsl:value-of select="concat(@name, '__')"/>
				<xsl:choose>
					<xsl:when test="form[@active='true'] = true()">
						<xsl:value-of select="form[@active='true']/@entity"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="form[1]/@entity"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text disable-output-escaping="yes">&apos;);</xsl:text>
			</xsl:for-each>
		</script>
		</head>
		<body
			class="gridmenu"
			onresize="top.Focus.resizeGridFrame()"
			oncontextmenu="return false"
			style="margin: 0 0 0 0;"
		>
			<xsl:attribute name="onload">
				<xsl:text disable-output-escaping="yes">init(&apos;</xsl:text>
					<xsl:choose>
						<xsl:when test="//tab[@active='true'] = true()">
							<xsl:value-of select="//tab[@active='true']/@name"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="//tab[1]/@name"/>
						</xsl:otherwise>
					</xsl:choose>
				<xsl:text disable-output-escaping="yes">&apos;)</xsl:text>
			</xsl:attribute>
			<table class="navigation" width="100%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td valign="center">
						<div id="navigationTab" style="white-space:nowrap; text-align:left; padding:1 1 2 2; visibility:hidden;">&#160;</div>
					</td>
					<td valign="center" align="right">
						<img src="/pics/popupmenu_tr.gif" onclick="top.Focus.getFocusFrame().showNavigationMenu(event)"/>
					</td>
				</tr>
			</table>
			<div id="navigationPopup" style="position:absolute;visibility:hidden;"/>
			<iframe	id="gridframe" src="/empty.jsp" style="width:100%; height:100%" frameborder="0"></iframe>
			<div id="gridTab">
				<xsl:apply-templates/>
			</div>
		</body>
		</html>
	</xsl:template>

	<xsl:template match="//tab">
		<div style="display:none;" id="{@name}">
		<xsl:variable name="mainTabId" select="@name"/>
		<xsl:for-each select="form">
			<xsl:if test="not(@grid) or @grid = 'true'">
				<xsl:variable name="caption">
					<xsl:choose>
						<xsl:when test="@caption">
							<xsl:copy-of select="string(@caption)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:copy-of select="string(@entity)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:element name="button">
					<xsl:attribute name="id"><xsl:value-of select="concat($mainTabId, '__', @entity)"/></xsl:attribute>
					<xsl:attribute name="mainTabId"><xsl:value-of select="$mainTabId"/></xsl:attribute>
					<!-- Data Sources Name {{{ -->
					<xsl:attribute name="entity">
						<xsl:value-of select="@entity"/>
					</xsl:attribute>
					<!-- Data Sources Name }}} -->
					<xsl:attribute name="title"><xsl:value-of select="$caption"/></xsl:attribute>
					<xsl:attribute name="class">passiveGridTab</xsl:attribute>
					<xsl:attribute name="onclick">parent.activateGridTab(this.id)</xsl:attribute>
					<xsl:value-of select="$caption"/>
				</xsl:element>
			</xsl:if>
		</xsl:for-each>
		</div>
	</xsl:template>

</xsl:stylesheet>
