# This structure acts as a simple authorization system for administrative side of
# the CMS
module Realapps
	module Cms
		module Authorization

			# Retrieves the username specified for protecting the CMS adminstration screens.
			def self.username
				@username
			end

			# Sets the username specified for protecting the CMS adminstration screens.
			def self.username=(value)
				@username = value
			end

			# Retrieves the password specified for protecting the CMS adminstration screens.
			def self.password
				@password
			end

			# Sets the password specified for protecting the CMS adminstration screens.
			def self.password=(value)
				@password = value
			end

			# Indicates if the username, password has been set up or not.
			def self.password_protected?
				# If the password or username are either blank or nil, then this site
				# is NOT password protected.
				! (@password.nil? || @username.nil? || @password.blank? || @username.blank?)
			end

			# Determine if username and password given match. If a username
			# and password have not been configured, will return false regardless.
			def self.check_credentials(u, p)
				if self.password_protected?
					u == @username && p == @password
				else
					false
				end
			end
		end
	end
end
