# ensure the proper model is available to us.
require 'cms_content'
require 'cms_authorization'
require 'cms_authorization_config'

class Realapps::CmsController < ApplicationController

	uses_component_template_root # Required statement for components
	layout nil # Layouts don't play well with components.
	before_filter :simple_authorize # Ensure all requests to CMS actions are authorized.

	def index
		list
		render :action => 'list'
	end

	def list
		@category_list = Realapps::CmsContent.category_list
		@contents = Realapps::CmsContent.find_by_category(params['cat'])
	end

	def show
		@content = Realapps::CmsContent.find(params[:id])
	end

	def new
		@category_list = Realapps::CmsContent.category_list
		@content = Realapps::CmsContent.new
		# Set category to current category, if any.
		@content.category = params['cat']
	end

	def create
		if @request.post?
			@content = Realapps::CmsContent.new
			# Set category outside transaction so value is preserved
			# in case of error. When rendering new page again, category
			# value is displayed.
			@content.category = params['cat']
			Realapps::CmsContent.transaction(@content) do
				begin
					@content.update_attributes(params[:content])
				rescue
					@content.errors.add_to_base $!.message
				end

				if @content.errors.empty?
					flash[:notice] = 'Content was successfully created.'
					# View category in which content was created, if any.
					redirect_to :action => 'list', :cat => @content.category
				else
					@category_list = Realapps::CmsContent.category_list
					render :action => 'new'
				end
			end
		else
			redirect_to :action => 'new'
		end
	end

	def edit
		@content = Realapps::CmsContent.find(params[:id])
		@category_list = Realapps::CmsContent.category_list
	end

	def update
		if @request.post?
			@content = Realapps::CmsContent.find(params[:id])
			Realapps::CmsContent.transaction(@content) do
				begin
					@content.update_attributes(params[:content])
				rescue
					@content.errors.add_to_base $!.message
				end
			end

			if @content.errors.empty?
				flash[:notice] = 'Content was successfully updated.'
				redirect_to :action => 'list', :cat => params['cat']
			else
				render :action => 'edit'
			end
		else
			redirect_to :action => "edit", :id => params[:id]
		end
	end

	def destroy
		Realapps::CmsContent.find(params[:id]).destroy
		flash[:notice] = "Content successfully deleted."
		redirect_to :action => 'list', :cat => params['cat']
	end

	def publish_all
		Realapps::CmsContent.publish_all
		flash[:notice] = "Content successfully published."
		redirect_to :action => 'list', :cat => params['cat']
	end

	def preview
		self.previewing = true
		redirect_to :controller => "/", :action => "index"
	end

	def production
		self.previewing = false
		redirect_to :controller => "/", :action => "index"
	end

	private

	# Simple basic, clear text authentication. Uses password and login
	# found in cms_authorization_config.rb
  def simple_authorize
		if Realapps::Cms::Authorization.password_protected?
			# extract authorization credentials
			username, password = get_credentials

			if Realapps::Cms::Authorization.check_credentials(username, password)
				return true
			else
				# the user does not exist or the password was wrong
				@response.headers["Status"] = "Unauthorized"
				@response.headers["WWW-Authenticate"] = "Basic realm=\"RealApps\""
				render_text("Unauthorized access", 401)
				return false
			end
		else
			# Username and password not configured - show message indicating such.
			render :partial => "not_configured"
			return false
		end
  end

  def get_credentials
		# Extract 'Basic' type authentication credentials from headers given.
		username, password = '', ''
		if authdata = (request.env['X-HTTP_AUTHORIZATION'] || request.env['HTTP_AUTHORIZATION'])
			authdata = authdata.to_s.split
			username, password = Base64.decode64(authdata[1]).split(':') if authdata.length > 0 && authdata[0] == 'Basic'
		end

		return username, password
  end

end
