class CmsMigration < ActiveRecord::Migration
  def self.up
		# Create the cms_contents and cms_contents_live tables with
		# exactly the same structure.
		%w(cms_contents cms_contents_live).each do |table_name|
			create_table table_name.to_sym, :force => true do |t|
					t.column :placement, :string, :null => false, :limit => 50
					t.column :category, :string, :null => true, :limit => 50
					t.column :location_notes, :string, :null => false, :limit => 250
					t.column :body, :text, :null => false
					t.column :published, :datetime, :null => true
					t.column :created, :datetime, :null => false
			end

			# Placement ID must be unique.
			add_index table_name.to_sym, :placement, :unique => true
		end
  end

  def self.down
    %w(cms_contents cms_contents_live).each { |table_name| drop_table table_name.to_sym }
  end
end
