#--
# Copyright (c) 2006 Kinetic Theory, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#++

# Extends ActionController so the methods within are available in any
# controller in the application.
class ActionController::Base
	# Retrieves content from the CMS and displays it. If the content is not found,
	# the empty string is displayed.
	def publish(placement_id)
		if self.previewing? then
			content = Realapps::CmsContent.find_preview_content(placement_id)
			# Prepend div identifying this content.
			content = render_to_string(:inline => PREVIEW_DIV, :locals => {:placement_id => placement_id }) + content

			# Add preview bar to output if we have not already done it once.
			unless @command_bar_placed
				@command_bar_placed = true
				content = content + render_to_string(:inline => COMMAND_BAR)
			end
		else
			content = Realapps::CmsContent.find_live_content(placement_id)
		end
		content
	end

	# Sets if current user is in 'preview' mode.
	def previewing=(value)
		session[:preview] = value && true
	end

	# True if previewing, false otherwise
	def previewing?
		session[:preview] && true
	end

	# Holds Javascript and HTML fragment for the preview command bar that appears along the
	# top of the page in preview mode. Notice this is really an RHTML template.
	COMMAND_BAR = <<-EOS
<script>
	function CMScontents(action)
	{
		t = document.getElementsByTagName("div")
		for(x=0; x<t.length; x++)
			if(t[x].id == 'CMSPREVIEW')
				if(action=='show')
					t[x].style.display = "block";
				else
					t[x].style.display = "none";
	}
</script>

<div style="width: 100%; background: yellow; position: fixed; top: 2px; left: 0px; padding: 5px;"><Strong>Preview Mode Active</strong>
&nbsp; &nbsp;
<a href="<%= url_for :controller => "realapps/cms", :action => "production" %>">Turn Preview Off</a>
&nbsp;
<a href="<%= url_for :controller => "realapps/cms", :action => "index" %>">Back to CMS</a>
&nbsp; &nbsp; &nbsp;
<a href="#nothing" onMouseOver="CMScontents('show');" onMouseOut="CMScontents('hide');">Highlight Content Areas</a>

</div>
	EOS

	# Holds HTML fragment prepended to each piece of managed content in preview mode.	Notice this
	# is really an RHTML template.
	PREVIEW_DIV = <<-EOS
<div style="background: yellow; position:absolute; padding: 2px;display:none;" id="CMSPREVIEW">
	CMS Content: <%= placement_id%>
</div>
	EOS
end
