/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.ImgPacksPanelAutomationHelper;
import com.izforge.izpack.panels.PacksModel;
import com.izforge.izpack.panels.PacksPanelInterface;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.n3.nanoxml.XMLElement;

public abstract class PacksPanelBase
extends IzPanel
implements PacksPanelInterface,
ListSelectionListener {
    protected JLabel freeSpaceLabel;
    protected JLabel spaceLabel;
    protected JTextArea descriptionArea;
    protected JTextArea dependencyArea;
    protected JTable packsTable;
    protected JScrollPane tableScroller;
    private Map names;
    protected int bytes = 0;
    protected long freeBytes = 0L;
    protected boolean dependenciesExist = false;
    private LocaleDatabase langpack = null;
    private static final String LANG_FILE_NAME = "packsLang.xml";

    public PacksPanelBase(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        try {
            this.langpack = parent.langpack;
            InputStream inputStream = ResourceManager.getInstance().getInputStream(LANG_FILE_NAME);
            this.langpack.add(inputStream);
        }
        catch (Throwable exception) {
            Debug.trace(exception);
        }
        this.computePacks(idata.availablePacks);
        this.createNormalLayout();
    }

    protected abstract void createNormalLayout();

    public LocaleDatabase getLangpack() {
        return this.langpack;
    }

    public int getBytes() {
        return this.bytes;
    }

    public void setBytes(int bytes) {
        this.bytes = bytes;
    }

    public void showSpaceRequired() {
        if (this.spaceLabel != null) {
            this.spaceLabel.setText(Pack.toByteUnitsString(this.bytes));
        }
    }

    public void showFreeSpace() {
        if (IoHelper.supported("getFreeSpace") && this.freeSpaceLabel != null) {
            String msg = null;
            this.freeBytes = IoHelper.getFreeSpace(IoHelper.existingParent(new File(this.idata.getInstallPath())).getAbsolutePath());
            msg = this.freeBytes > Integer.MAX_VALUE ? " > 2 GB" : (this.freeBytes < 0L ? this.parent.langpack.getString("PacksPanel.notAscertainable") : Pack.toByteUnitsString((int)this.freeBytes));
            this.freeSpaceLabel.setText(msg);
        }
    }

    public boolean isValidated() {
        if (IoHelper.supported("getFreeSpace") && this.freeBytes >= 0L && this.freeBytes <= (long)this.bytes) {
            JOptionPane.showMessageDialog(this, this.parent.langpack.getString("PacksPanel.notEnoughSpace"), this.parent.langpack.getString("installer.error"), 0);
            return false;
        }
        return true;
    }

    public void makeXMLData(XMLElement panelRoot) {
        new ImgPacksPanelAutomationHelper().makeXMLData(this.idata, panelRoot);
    }

    public void valueChanged(ListSelectionEvent e) {
        Pack pack;
        int i = this.packsTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        if (this.descriptionArea != null) {
            pack = (Pack)this.idata.availablePacks.get(i);
            String desc = "";
            String key = pack.id + ".description";
            if (this.langpack != null && pack.id != null && !pack.id.equals("")) {
                desc = this.langpack.getString(key);
            }
            if (desc.equals("") || key.equals(desc)) {
                desc = pack.description;
            }
            this.descriptionArea.setText(desc);
        }
        if (this.dependencyArea != null) {
            pack = (Pack)this.idata.availablePacks.get(i);
            List dep = pack.dependencies;
            String list = "";
            for (int j = 0; dep != null && j < dep.size(); ++j) {
                String name = (String)dep.get(j);
                Pack childPack = (Pack)this.names.get(name);
                String childName = "";
                String key = childPack.id;
                if (this.langpack != null && childPack.id != null && !childPack.id.equals("")) {
                    childName = this.langpack.getString(key);
                }
                if (childName.equals("") || key.equals(childName)) {
                    childName = childPack.name;
                }
                list = list + childName;
                if (j == dep.size() - 1) continue;
                list = list + ", ";
            }
            this.dependencyArea.setText(list);
        }
    }

    protected JLabel createLabel(String msgId, String iconId, GridBagLayout layout, GridBagConstraints constraints) {
        JLabel label = LabelFactory.create(this.parent.langpack.getString(msgId), this.parent.icons.getImageIcon(iconId), 11);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(label, constraints);
        }
        this.add(label);
        return label;
    }

    protected JLabel createPanelWithLabel(String msgId, GridBagLayout layout, GridBagConstraints constraints) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel();
        if (label == null) {
            label = new JLabel("");
        }
        panel.setAlignmentX(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(LabelFactory.create(this.parent.langpack.getString(msgId)));
        panel.add(Box.createHorizontalGlue());
        panel.add(label);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(panel, constraints);
        }
        this.add(panel);
        return label;
    }

    protected JTextArea createTextArea(String msgId, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTextArea area = new JTextArea();
        area.setMargin(new Insets(2, 2, 2, 2));
        area.setAlignmentX(0.0f);
        area.setCaretPosition(0);
        area.setEditable(false);
        area.setEditable(false);
        area.setOpaque(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString(msgId)));
        if (layout != null && constraints != null) {
            if (scroller != null) {
                layout.addLayoutComponent(scroller, constraints);
            } else {
                layout.addLayoutComponent(area, constraints);
            }
        }
        if (scroller != null) {
            scroller.setViewportView(area);
            this.add(scroller);
        } else {
            this.add(area);
        }
        return area;
    }

    protected JTable createPacksTable(int width, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTable table = new JTable();
        table.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        table.setIntercellSpacing(new Dimension(0, 0));
        table.setBackground(Color.white);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(this);
        table.setShowGrid(false);
        scroller.setViewportView(table);
        scroller.setAlignmentX(0.0f);
        scroller.getViewport().setBackground(Color.white);
        scroller.setPreferredSize(new Dimension(width, this.idata.guiPrefs.height / 3 + 30));
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(scroller, constraints);
        }
        this.add(scroller);
        return table;
    }

    private void computePacks(List packs) {
        this.names = new HashMap();
        this.dependenciesExist = false;
        for (int i = 0; i < packs.size(); ++i) {
            Pack pack = (Pack)packs.get(i);
            this.names.put(pack.name, pack);
            if (pack.dependencies == null) continue;
            this.dependenciesExist = true;
        }
    }

    public void panelActivate() {
        try {
            this.packsTable.setModel(new PacksModel(this.idata.availablePacks, this.idata.selectedPacks, this));
            CheckBoxEditorRenderer packSelectedRenderer = new CheckBoxEditorRenderer(false);
            this.packsTable.getColumnModel().getColumn(0).setCellRenderer(packSelectedRenderer);
            CheckBoxEditorRenderer packSelectedEditor = new CheckBoxEditorRenderer(true);
            this.packsTable.getColumnModel().getColumn(0).setCellEditor(packSelectedEditor);
            this.packsTable.getColumnModel().getColumn(0).setMaxWidth(40);
            DefaultTableCellRenderer renderer1 = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 3256438101604710708L;

                public void setBorder(Border b) {
                }
            };
            this.packsTable.getColumnModel().getColumn(1).setCellRenderer(renderer1);
            DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 4121128130480976185L;

                public void setBorder(Border b) {
                }
            };
            renderer2.setHorizontalAlignment(4);
            this.packsTable.getColumnModel().getColumn(2).setCellRenderer(renderer2);
            this.packsTable.getColumnModel().getColumn(2).setMaxWidth(100);
            this.tableScroller.remove(this.packsTable.getTableHeader());
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            Iterator iter = this.idata.availablePacks.iterator();
            this.bytes = 0;
            while (iter.hasNext()) {
                Pack p = (Pack)iter.next();
                if (p.required) {
                    this.bytes = (int)((long)this.bytes + p.nbytes);
                    continue;
                }
                if (!this.idata.selectedPacks.contains(p)) continue;
                this.bytes = (int)((long)this.bytes + p.nbytes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showSpaceRequired();
        this.showFreeSpace();
    }

    public String getSummaryBody() {
        StringBuffer retval = new StringBuffer(256);
        Iterator iter = this.idata.selectedPacks.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (!first) {
                retval.append("<br>");
            }
            first = false;
            Pack pack = (Pack)iter.next();
            if (this.langpack != null && pack.id != null && !pack.id.equals("")) {
                retval.append(this.langpack.getString(pack.id));
                continue;
            }
            retval.append(pack.name);
        }
        return retval.toString();
    }

    static class CheckBoxEditorRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 4049072731222061879L;
        private JCheckBox display = new JCheckBox();

        public CheckBoxEditorRenderer(boolean useAsEditor) {
            this.display.setHorizontalAlignment(0);
            if (useAsEditor) {
                this.display.addActionListener(this);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.display.setForeground(table.getSelectionForeground());
                this.display.setBackground(table.getSelectionBackground());
            } else {
                this.display.setForeground(table.getForeground());
                this.display.setBackground(table.getBackground());
            }
            int state = (Integer)value;
            this.display.setSelected(value != null && Math.abs(state) == 1);
            this.display.setEnabled(state >= 0);
            return this.display;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }

        public Object getCellEditorValue() {
            return new Integer(this.display.isSelected() ? 1 : 0);
        }

        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }
    }
}

