/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.File;
import java.util.ArrayList;

public class StringTool {
    public static void main(String[] args) {
        System.out.println("Test: string.replace(abc$defg,$de ,null ):" + StringTool.replace("abc$defg", "$de", null, true));
    }

    public static String replace(String value, String from, String to) {
        return StringTool.replace(value, from, to, true);
    }

    public static String replace(String value, String from, String to, boolean aCaseSensitiveFlag) {
        if (value == null || value.length() == 0 || from == null || from.length() == 0) {
            return value;
        }
        if (to == null) {
            to = "";
        }
        if (!aCaseSensitiveFlag) {
            from = from.toLowerCase();
        }
        String result = value;
        int lastIndex = 0;
        int index = value.indexOf(from);
        if (index != -1) {
            StringBuffer buffer = new StringBuffer();
            while (index != -1) {
                buffer.append(value.substring(lastIndex, index)).append(to);
                lastIndex = index + from.length();
                index = value.indexOf(from, lastIndex);
            }
            buffer.append(value.substring(lastIndex));
            result = buffer.toString();
        }
        return result;
    }

    public static String normalizePath(String destination, String fileSeparator) {
        String FILESEP = fileSeparator == null ? File.separator : fileSeparator;
        destination = StringTool.replace(destination, "\\", "/");
        destination = StringTool.replace(destination, "//", "/");
        destination = StringTool.replace(destination, ":", ";");
        destination = StringTool.replace(destination, ";", ":");
        destination = StringTool.replace(destination, "/", FILESEP);
        if ("\\".equals(FILESEP)) {
            destination = StringTool.replace(destination, ":", ";");
            destination = StringTool.replace(destination, ";\\", ":\\");
        }
        return destination;
    }

    public static String normalizePath(String destination) {
        return StringTool.normalizePath(destination, null);
    }

    public static String stringArrayToSpaceSeparatedString(String[] args) {
        String result = "";
        for (int idx = 0; idx < args.length; ++idx) {
            result = result + args[idx] + " ";
        }
        return result;
    }

    public static String getPlatformEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String UTF16() {
        return "UTF-16";
    }

    public static String stringArrayListToString(ArrayList aStringList) {
        StringBuffer temp = new StringBuffer();
        for (int idx = 0; idx < aStringList.size(); ++idx) {
            temp.append(aStringList.get(idx) + "\n");
        }
        return temp.toString();
    }

    public static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str != null && prefix != null && str.toUpperCase().startsWith(prefix.toUpperCase());
    }
}

