# makeTargetDirs(<file1> ... <fileN>)
function(makeTargetDirs)
	foreach(TargetFile ${ARGV})
		get_filename_component(TargetAbsPath ${TargetFile} PATH)
		if(TargetAbsPath)
			if(NOT IS_ABSOLUTE ${TargetAbsPath})
				set(TargetAbsPath ${CMAKE_CURRENT_BINARY_DIR}/${TargetAbsPath})
			endif()
			if(NOT EXISTS ${TargetAbsPath})
				file(MAKE_DIRECTORY ${TargetAbsPath})
			endif()
		endif()
	endforeach()
endfunction()