/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.FileCache;
import gov.nasa.worldwind.WorldWind;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFileCache
implements FileCache {
    private final LinkedList<File> cacheDirs = new LinkedList();
    private File cacheWriteDir = null;

    protected void initialize(InputStream inputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            String string;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            this.buildWritePaths(document);
            this.buildReadPaths(document);
            if (this.cacheWriteDir == null) {
                string = WorldWind.retrieveErrMsg("FileCache.NoFileCacheWriteLocation");
                WorldWind.logger().log(Level.FINE, string);
            }
            if (this.cacheDirs.size() == 0) {
                string = WorldWind.retrieveErrMsg("FileCache.NoFileCacheReadLocations");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalStateException(string);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void addCacheLocation(String string) {
        this.addCacheLocation(this.cacheDirs.size(), string);
    }

    @Override
    public void addCacheLocation(int n, String string) {
        File file;
        if (string == null || string.length() == 0) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.FileCachePathIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (n < 0) {
            String string3 = WorldWind.retrieveErrMsg("generic.invalidIndex");
            WorldWind.logger().log(Level.FINE, string3);
            throw new IllegalArgumentException(string3);
        }
        if (n > 0 && n > this.cacheDirs.size()) {
            n = this.cacheDirs.size();
        }
        if (this.cacheDirs.contains(file = new File(string))) {
            this.cacheDirs.remove(file);
        }
        this.cacheDirs.add(n, file);
    }

    @Override
    public void removeCacheLocation(String string) {
        if (string == null || string.length() == 0) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.FileCachePathIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            return;
        }
        File file = new File(string);
        if (file.equals(this.cacheWriteDir)) {
            String string3 = WorldWind.retrieveErrMsg("FileCache.CannotRemoveWriteLocationFromSearchList");
            WorldWind.logger().log(Level.FINE, string3);
            throw new IllegalArgumentException(string3);
        }
        this.cacheDirs.remove(new File(string));
    }

    @Override
    public List<File> getCacheLocations() {
        return new LinkedList<File>(this.cacheDirs);
    }

    @Override
    public File getWriteLocation() {
        return this.cacheWriteDir;
    }

    private void buildReadPaths(Node node) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.evaluate("/dataFileCache/readLocations/location", node.getFirstChild(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Node node2 = nodeList.item(i);
                String string = xPath.evaluate("@property", node2);
                String string2 = xPath.evaluate("@wwDir", node2);
                String string3 = xPath.evaluate("@append", node2);
                String string4 = AbstractFileCache.buildLocationPath(string, string3, string2);
                if (string4 == null) {
                    object = WorldWind.retrieveErrMsg("FileCache.CacheLocationInvalid");
                    object = (String)object + (string != null ? string : WorldWind.retrieveErrMsg("generic.unknown"));
                    WorldWind.logger().log(Level.FINE, (String)object);
                    continue;
                }
                object = new File(string4);
                if (((File)object).exists() && !((File)object).isDirectory()) {
                    String string5 = WorldWind.retrieveErrMsg("FileCache.CacheLocationIsFile");
                    string5 = string5 + ((File)object).getPath();
                    WorldWind.logger().log(Level.FINER, string5);
                }
                if (this.cacheDirs.contains(object)) continue;
                this.cacheDirs.add((File)object);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
    }

    private void buildWritePaths(Node node) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.evaluate("/dataFileCache/writeLocations/location", node.getFirstChild(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Node node2 = nodeList.item(i);
                String string = xPath.evaluate("@property", node2);
                String string2 = xPath.evaluate("@wwDir", node2);
                String string3 = xPath.evaluate("@append", node2);
                String string4 = xPath.evaluate("@create", node2);
                String string5 = AbstractFileCache.buildLocationPath(string, string3, string2);
                if (string5 == null) {
                    object = WorldWind.retrieveErrMsg("FileCache.CacheLocationInvalid");
                    object = (String)object + (string != null ? string : WorldWind.retrieveErrMsg("generic.unknown"));
                    WorldWind.logger().log(Level.FINE, (String)object);
                    continue;
                }
                object = new File(string5);
                if (!((File)object).exists() && string4 != null && (string4.contains("t") || string4.contains("T"))) {
                    ((File)object).mkdirs();
                }
                if (!((File)object).isDirectory() || !((File)object).canWrite() || !((File)object).canRead()) continue;
                this.cacheWriteDir = object;
                this.cacheDirs.addFirst((File)object);
                break;
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
    }

    private static String buildLocationPath(String string, String string2, String string3) {
        String string4 = AbstractFileCache.propertyToPath(string);
        if (string2 != null && string2.length() != 0) {
            string4 = AbstractFileCache.appendPathPart(string4, string2.trim());
        }
        if (string3 != null && string3.length() != 0) {
            string4 = AbstractFileCache.appendPathPart(string4, string3.trim());
        }
        return string4;
    }

    private static String appendPathPart(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string == null || string2.length() == 0) {
            return string2;
        }
        string = AbstractFileCache.stripTrailingSeparator(string);
        string2 = AbstractFileCache.stripLeadingSeparator(string2);
        return string + System.getProperty("file.separator") + string2;
    }

    private static String stripTrailingSeparator(String string) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String stripLeadingSeparator(String string) {
        if (string.startsWith("/") || string.startsWith("\\")) {
            return string.substring(1, string.length());
        }
        return string;
    }

    private static String propertyToPath(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        if (string.equalsIgnoreCase("gov.nasa.worldwind.platform.alluser.cache")) {
            return AbstractFileCache.determineAllUserCacheDir();
        }
        if (string.equalsIgnoreCase("gov.nasa.worldwind.platform.user.cache")) {
            return AbstractFileCache.determineSingleUserCacheDir();
        }
        return null;
    }

    private static String determineAllUserCacheDir() {
        if (Configuration.isMacOS()) {
            return "/Library/Caches";
        }
        if (Configuration.isWindowsOS()) {
            String string = System.getenv("ALLUSERSPROFILE");
            if (string == null) {
                String string2 = WorldWind.retrieveErrMsg("generic.AllUsersWindowsProfileNotKnown");
                WorldWind.logger().log(Level.FINE, string2);
                return null;
            }
            return string + "\\Application Data";
        }
        if (Configuration.isLinuxOS() || Configuration.isUnixOS() || Configuration.isSolarisOS()) {
            return "/var/cache/";
        }
        String string = WorldWind.retrieveErrMsg("generic.UnknownOperatingSystem");
        WorldWind.logger().log(Level.FINE, string);
        return null;
    }

    private static String determineSingleUserCacheDir() {
        String string = AbstractFileCache.getUserHomeDir();
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("generic.UsersHomeDirectoryNotKnown");
            WorldWind.logger().log(Level.FINE, string2);
            return null;
        }
        String string3 = null;
        if (Configuration.isMacOS()) {
            string3 = "/Library/Caches";
        } else if (Configuration.isWindowsOS()) {
            string3 = System.getenv("USERPROFILE");
            if (string3 == null) {
                String string4 = WorldWind.retrieveErrMsg("generic.UsersWindowsProfileNotKnown");
                WorldWind.logger().log(Level.FINE, string4);
                return null;
            }
            string3 = string3 + "\\Application Data";
        } else if (Configuration.isLinuxOS() || Configuration.isUnixOS() || Configuration.isSolarisOS()) {
            string3 = "/var/cache/";
        } else {
            String string5 = WorldWind.retrieveErrMsg("generic.UnknownOperatingSystem");
            WorldWind.logger().log(Level.FINE, string5);
        }
        if (string3 == null) {
            return null;
        }
        return string + string3;
    }

    private static String getUserHomeDir() {
        return System.getProperty("user.home");
    }

    @Override
    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        for (File file : this.cacheDirs) {
            File file2 = string.startsWith(file.getAbsolutePath()) ? new File(string) : this.cachePathForFile(file, string);
            if (!file2.exists()) continue;
            return true;
        }
        return false;
    }

    private File cachePathForFile(File file, String string) {
        return new File(file.getAbsolutePath() + "/" + string);
    }

    private String makeFullPath(File file, String string) {
        return file.getAbsolutePath() + "/" + string;
    }

    @Override
    public File newFile(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.FilePathIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.cacheWriteDir != null) {
            String string3 = this.makeFullPath(this.cacheWriteDir, string);
            File file = new File(string3);
            if (file.getParentFile().exists()) {
                return file;
            }
            if (file.getParentFile().mkdirs()) {
                return file;
            }
            return null;
        }
        return null;
    }

    @Override
    public URL findFile(String string, boolean bl) {
        Object object;
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.FilePathIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (bl && (object = this.getClass().getClassLoader().getResource(string)) != null) {
            return object;
        }
        for (File file : this.cacheDirs) {
            File file2;
            if (!file.exists() || !(file2 = new File(this.makeFullPath(file, string))).exists()) continue;
            try {
                return file2.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                String string3 = WorldWind.retrieveErrMsg("FileCache.ExceptionCreatingURLForFile");
                WorldWind.logger().log(Level.FINE, string3 + file2.getPath());
            }
        }
        return null;
    }

    @Override
    public void removeFile(URL uRL) {
        if (uRL == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.URLIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        try {
            File file = new File(uRL.toURI());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            String string = WorldWind.retrieveErrMsg("FileCache.ExceptionRemovingFile");
            WorldWind.logger().log(Level.FINE, string + uRL);
        }
    }
}

