/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.BasicMemoryCache;
import gov.nasa.worldwind.Cacheable;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.ElevationModel;
import gov.nasa.worldwind.HTTPRetriever;
import gov.nasa.worldwind.Level;
import gov.nasa.worldwind.LevelSet;
import gov.nasa.worldwind.MemoryCache;
import gov.nasa.worldwind.RetrievalPostProcessor;
import gov.nasa.worldwind.Retriever;
import gov.nasa.worldwind.TileKey;
import gov.nasa.worldwind.URLRetriever;
import gov.nasa.worldwind.WWIO;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class BasicElevationModel
extends WWObjectImpl
implements ElevationModel {
    private boolean isEnabled = true;
    private final LevelSet levels;
    private final double minElevation;
    private final double maxElevation;
    private long numExpectedValues = 0L;
    private final Object fileLock = new Object();
    private ConcurrentHashMap<TileKey, Tile> levelZeroTiles = new ConcurrentHashMap();
    private MemoryCache memoryCache = new BasicMemoryCache(8000000L, 10000000L);

    public BasicElevationModel(LevelSet levelSet, double d, double d2) {
        if (levelSet == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LevelSetIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.levels = new LevelSet(levelSet);
        this.minElevation = d;
        this.maxElevation = d2;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public LevelSet getLevels() {
        return this.levels;
    }

    public final double getMaximumElevation() {
        return this.maxElevation;
    }

    public final double getMinimumElevation() {
        return this.minElevation;
    }

    public long getNumExpectedValuesPerTile() {
        return this.numExpectedValues;
    }

    public void setNumExpectedValuesPerTile(long l) {
        this.numExpectedValues = l;
    }

    private Tile createTile(TileKey tileKey) {
        Level level = this.levels.getLevel(tileKey.getLevelNumber());
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = Tile.computeRowLatitude(tileKey.getRow(), angle);
        Angle angle4 = Tile.computeColumnLongitude(tileKey.getColumn(), angle2);
        Sector sector = new Sector(angle3, angle3.add(angle), angle4, angle4.add(angle2));
        return new Tile(sector, level, tileKey.getRow(), tileKey.getColumn());
    }

    private void requestTile(TileKey tileKey) {
        if (WorldWind.threadedTaskService().isFull()) {
            return;
        }
        RequestTask requestTask = new RequestTask(tileKey, this);
        WorldWind.threadedTaskService().addTask(requestTask);
    }

    private boolean loadElevations(Tile tile, URL uRL) {
        ShortBuffer shortBuffer = this.readElevations(uRL);
        if (shortBuffer == null) {
            return false;
        }
        if (this.numExpectedValues > 0L && (long)shortBuffer.capacity() != this.numExpectedValues) {
            return false;
        }
        tile.elevations = shortBuffer;
        this.addTileToCache(tile, shortBuffer);
        return true;
    }

    private void addTileToCache(Tile tile, ShortBuffer shortBuffer) {
        if (tile.getLevelNumber() == 0) {
            this.levelZeroTiles.putIfAbsent(tile.getTileKey(), tile);
        } else {
            this.memoryCache.add(tile.getTileKey(), tile, shortBuffer.limit() * 2);
        }
    }

    private boolean areElevationsInMemory(TileKey tileKey) {
        Tile tile = this.getTileFromMemory(tileKey);
        return tile != null && tile.elevations != null;
    }

    private Tile getTileFromMemory(TileKey tileKey) {
        if (tileKey.getLevelNumber() == 0) {
            return this.levelZeroTiles.get(tileKey);
        }
        return (Tile)this.memoryCache.getObject(tileKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShortBuffer readElevations(URL uRL) {
        try {
            ByteBuffer byteBuffer;
            Object object = this.fileLock;
            synchronized (object) {
                byteBuffer = WWIO.readURLContentToBuffer(uRL);
            }
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            return byteBuffer.asShortBuffer();
        }
        catch (IOException iOException) {
            String string = WorldWind.retrieveErrMsg("TiledElevationModel.ExceptionAttemptingToReadTextureFile");
            WorldWind.logger().log(java.util.logging.Level.FINE, string + uRL);
            return null;
        }
    }

    private void downloadElevations(Tile tile) {
        if (WorldWind.retrievalService().isFull()) {
            return;
        }
        URL uRL = null;
        try {
            uRL = tile.getResourceURL();
        }
        catch (MalformedURLException malformedURLException) {
            String string = WorldWind.retrieveErrMsg("TiledElevationModel.ExceptionCreatingElevationsUrl");
            WorldWind.logger().log(java.util.logging.Level.FINE, string + uRL, malformedURLException);
            return;
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new DownloadPostProcessor(tile, this));
        if (WorldWind.retrievalService().contains(hTTPRetriever)) {
            return;
        }
        WorldWind.retrievalService().runRetriever(hTTPRetriever, 0.0);
    }

    public final int getTargetResolution(DrawContext drawContext, Sector sector, int n) {
        Object object;
        if (!this.isEnabled) {
            return 0;
        }
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.SectorIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            object = WorldWind.retrieveErrMsg("BasicElevationModel.DensityBelowZero");
            WorldWind.logger().log(java.util.logging.Level.FINEST, (String)object);
        }
        object = this.levels.getSector().getCentroid();
        double d = drawContext.getGlobe().getRadiusAt(((LatLon)object).getLatitude(), ((LatLon)object).getLongitude());
        double d2 = sector.getDeltaLatRadians() * d;
        double d3 = 0.8 * d2 / (double)n;
        for (Level level : this.levels.getLevels()) {
            if (!(level.getTexelSize(d) < d3)) continue;
            return level.getLevelNumber();
        }
        return this.levels.getNumLevels();
    }

    public final double getElevation(Angle angle, Angle angle2) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        TileKey tileKey = new TileKey(angle, angle2, this.levels.getLastLevel());
        Tile tile = this.getTileFromMemory(tileKey);
        if (tile == null) {
            TileKey tileKey2;
            int n = tileKey.getRow();
            int n2 = tileKey.getColumn();
            for (int i = tileKey.getLevelNumber() - 1; i >= 0 && (tile = this.getTileFromMemory(tileKey2 = new TileKey(i, n /= 2, n2 /= 2, this.levels.getLevel(i).getCacheName()))) == null; --i) {
            }
        }
        if (tile == null) {
            TileKey tileKey3 = new TileKey(angle, angle2, this.levels.getFirstLevel());
            this.requestTile(tileKey3);
            return 0.0;
        }
        return this.lookupElevation(angle.radians, angle2.radians, tile);
    }

    public final ElevationModel.Elevations getElevations(Sector sector, int n) {
        if (sector == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.SectorIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isEnabled()) {
            return new BasicElevations(sector, Integer.MIN_VALUE, this);
        }
        Level level = this.levels.getLevel(n);
        TileKey tileKey = new TileKey(sector.getMaxLatitude(), sector.getMinLongitude(), this.levels.getLevel(n));
        TileKey tileKey2 = new TileKey(sector.getMinLatitude(), sector.getMaxLongitude(), this.levels.getLevel(n));
        TreeSet<Tile> treeSet = new TreeSet<Tile>();
        ArrayList<TileKey> arrayList = new ArrayList<TileKey>();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = tileKey2.getRow(); i <= tileKey.getRow(); ++i) {
            for (int j = tileKey.getColumn(); j <= tileKey2.getColumn(); ++j) {
                TileKey tileKey3 = new TileKey(n, i, j, level.getCacheName());
                Tile tile = this.getTileFromMemory(tileKey3);
                if (tile != null) {
                    treeSet.add(tile);
                    continue;
                }
                bl = true;
                this.requestTile(tileKey3);
                TileKey tileKey4 = null;
                TileKey tileKey5 = null;
                int n2 = i;
                int n3 = j;
                for (int k = tileKey3.getLevelNumber() - 1; k >= 0; --k) {
                    tileKey5 = new TileKey(k, n2 /= 2, n3 /= 2, this.levels.getLevel(k).getCacheName());
                    tile = this.getTileFromMemory(tileKey5);
                    if (tile != null) {
                        if (treeSet.contains(tile)) break;
                        treeSet.add(tile);
                        break;
                    }
                    if (k == 0) {
                        bl2 = true;
                    }
                    tileKey4 = tileKey5;
                }
                if (tileKey4 == null || arrayList.contains(tileKey5)) continue;
                this.requestTile(tileKey5);
                arrayList.add(tileKey5);
            }
        }
        BasicElevations basicElevations = bl2 || treeSet.isEmpty() ? new BasicElevations(sector, Integer.MIN_VALUE, this) : (bl ? new BasicElevations(sector, ((Tile)treeSet.first()).getLevelNumber(), this) : new BasicElevations(sector, n, this));
        basicElevations.tiles = treeSet;
        return basicElevations;
    }

    private double lookupElevation(double d, double d2, Tile tile) {
        Sector sector = tile.getSector();
        int n = tile.getLevel().getTileHeight();
        int n2 = tile.getLevel().getTileWidth();
        double d3 = sector.getDeltaLat().radians;
        double d4 = sector.getDeltaLon().radians;
        double d5 = sector.getMaxLatitude().radians - d;
        double d6 = d2 - sector.getMinLongitude().radians;
        double d7 = d5 / d3;
        double d8 = d6 / d4;
        int n3 = (int)((double)(n - 1) * d7);
        int n4 = (int)((double)(n2 - 1) * d8);
        int n5 = n3 * n2 + n4;
        double d9 = tile.elevations.get(n5);
        double d10 = n4 < n2 - 1 ? (double)tile.elevations.get(n5 + 1) : d9;
        double d11 = d4 / (double)(n2 - 1);
        double d12 = d3 / (double)(n - 1);
        double d13 = (d6 - (double)n4 * d11) / d11;
        double d14 = (d5 - (double)n3 * d12) / d12;
        double d15 = d9 + d13 * (d10 - d9);
        if (n3 < n - 1 && n4 < n2 - 1) {
            d9 = tile.elevations.get(n5 + n2);
            d10 = tile.elevations.get(n5 + n2 + 1);
        }
        double d16 = d9 + d13 * (d10 - d9);
        return d15 + d14 * (d16 - d15);
    }

    private static class BasicElevations
    implements ElevationModel.Elevations {
        private final int resolution;
        private final Sector sector;
        private final BasicElevationModel elevationModel;
        private Set<Tile> tiles;

        private BasicElevations(Sector sector, int n, BasicElevationModel basicElevationModel) {
            this.sector = sector;
            this.resolution = n;
            this.elevationModel = basicElevationModel;
        }

        public int getResolution() {
            return this.resolution;
        }

        public Sector getSector() {
            return this.sector;
        }

        public boolean hasElevations() {
            return this.tiles != null && this.tiles.size() > 0;
        }

        public double getElevation(double d, double d2) {
            if (this.tiles == null) {
                return 0.0;
            }
            try {
                for (Tile tile : this.tiles) {
                    if (!tile.getSector().containsRadians(d, d2)) continue;
                    return this.elevationModel.lookupElevation(d, d2, tile);
                }
                return 0.0;
            }
            catch (Exception exception) {
                String string = WorldWind.retrieveErrMsg("BasicElevationModel.ExceptionComputingElevation");
                string = string + "(" + d + ", " + d2 + ")";
                WorldWind.logger().log(java.util.logging.Level.FINE, string, exception);
                return 0.0;
            }
        }
    }

    private static class DownloadPostProcessor
    implements RetrievalPostProcessor {
        private Tile tile;
        private BasicElevationModel elevationModel;

        public DownloadPostProcessor(Tile tile, BasicElevationModel basicElevationModel) {
            this.tile = tile;
            this.elevationModel = basicElevationModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer run(Retriever retriever) {
            block17: {
                Object object;
                if (retriever == null) {
                    String string = WorldWind.retrieveErrMsg("nullValue.RetrieverIsNull");
                    WorldWind.logger().log(java.util.logging.Level.FINE, string);
                    throw new IllegalArgumentException(string);
                }
                try {
                    URLRetriever uRLRetriever;
                    if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                        ByteBuffer byteBuffer = null;
                        return byteBuffer;
                    }
                    if (retriever instanceof HTTPRetriever && ((HTTPRetriever)(uRLRetriever = (HTTPRetriever)retriever)).getResponseCode() != 200) {
                        this.elevationModel.levels.markResourceAbsent(this.tile);
                        ByteBuffer byteBuffer = null;
                        return byteBuffer;
                    }
                    uRLRetriever = (URLRetriever)retriever;
                    object = uRLRetriever.getBuffer();
                    File file = WorldWind.dataFileCache().newFile(this.tile.getPath());
                    if (file == null) {
                        String string = WorldWind.retrieveErrMsg("generic.CantCreateCacheFile") + this.tile.getPath();
                        WorldWind.logger().log(java.util.logging.Level.FINE, string);
                        ByteBuffer byteBuffer = null;
                        return byteBuffer;
                    }
                    if (file.exists()) {
                        Object object2 = object;
                        return object2;
                    }
                    if (object == null) break block17;
                    Object object3 = this.elevationModel.fileLock;
                    synchronized (object3) {
                        WWIO.saveBuffer((ByteBuffer)object, file);
                    }
                    object3 = object;
                    return object3;
                }
                catch (IOException iOException) {
                    object = WorldWind.retrieveErrMsg("TiledElevationModel.ExceptionSavingRetrievedElevationFile");
                    WorldWind.logger().log(java.util.logging.Level.FINE, (String)object + this.tile.getPath(), iOException);
                }
                finally {
                    this.elevationModel.firePropertyChange("gov.nasa.worldwind.avkey.ElevationModel", null, this);
                }
            }
            return null;
        }
    }

    private static class RequestTask
    implements Runnable {
        private final BasicElevationModel elevationModel;
        private final TileKey tileKey;

        private RequestTask(TileKey tileKey, BasicElevationModel basicElevationModel) {
            this.elevationModel = basicElevationModel;
            this.tileKey = tileKey;
        }

        public final void run() {
            if (this.elevationModel.areElevationsInMemory(this.tileKey)) {
                return;
            }
            Tile tile = this.elevationModel.createTile(this.tileKey);
            URL uRL = WorldWind.dataFileCache().findFile(tile.getPath(), false);
            if (uRL != null) {
                if (this.elevationModel.loadElevations(tile, uRL)) {
                    this.elevationModel.levels.unmarkResourceAbsent(tile);
                    this.elevationModel.firePropertyChange("gov.nasa.worldwind.avkey.ElevationModel", null, this);
                    return;
                }
                WorldWind.dataFileCache().removeFile(uRL);
                this.elevationModel.levels.markResourceAbsent(tile);
                String string = WorldWind.retrieveErrMsg("generic.DeletedCorruptDataFile") + uRL;
                WorldWind.logger().log(java.util.logging.Level.FINE, string);
            }
            this.elevationModel.downloadElevations(tile);
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tileKey != null ? !this.tileKey.equals(requestTask.tileKey) : requestTask.tileKey != null);
        }

        public final int hashCode() {
            return this.tileKey != null ? this.tileKey.hashCode() : 0;
        }

        public final String toString() {
            return this.tileKey.toString();
        }
    }

    private static final class Tile
    extends gov.nasa.worldwind.Tile
    implements Cacheable {
        private ShortBuffer elevations;

        private Tile(Sector sector, Level level, int n, int n2) {
            super(sector, level, n, n2);
        }
    }
}

