/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.RetrievalFuture;
import gov.nasa.worldwind.RetrievalService;
import gov.nasa.worldwind.Retriever;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import java.net.SocketTimeoutException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class BasicRetrievalService
extends WWObjectImpl
implements RetrievalService,
Thread.UncaughtExceptionHandler {
    private static final int DEFAULT_QUEUE_SIZE = 100;
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final long DEFAULT_STALE_REQUEST_LIMIT = 30000L;
    private static final int DEFAULT_TIME_PRIORITY_GRANULARITY = 500;
    private static final String RUNNING_THREAD_NAME_PREFIX = WorldWind.retrieveMessage("BasicRetrievalService.RUNNING_THREAD_NAME_PREFIX", "ThreadStrings");
    private static final String IDLE_THREAD_NAME_PREFIX = WorldWind.retrieveMessage("BasicRetrievalService.IDLE_THREAD_NAME_PREFIX", "ThreadStrings");
    private RetrievalExecutor executor;
    private ConcurrentLinkedQueue<RetrievalTask> activeTasks;
    private int queueSize;

    public void uncaughtException(Thread thread, Throwable throwable) {
        String string = WorldWind.retrieveErrMsg("BasicRetrievalService.UncaughtExceptionDuringRetrieval") + thread.getName();
        WorldWind.logger().log(Level.FINE, string);
    }

    public BasicRetrievalService() {
        Integer n = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.RetrievalPoolSize", 5);
        this.queueSize = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.RetrievalQueueSize", 100);
        this.executor = new RetrievalExecutor(n, this.queueSize);
        this.activeTasks = new ConcurrentLinkedQueue();
    }

    public RetrievalFuture runRetriever(Retriever retriever) {
        if (retriever == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RetrieverIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (retriever.getName() == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RetrieverNameIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.runRetriever(retriever, Long.MAX_VALUE - System.currentTimeMillis());
    }

    public synchronized RetrievalFuture runRetriever(Retriever retriever, double d) {
        Object object;
        if (retriever == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RetrieverIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (retriever.getName() == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RetrieverNameIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.isFull()) {
            object = retriever.getName();
            String string = WorldWind.retrieveErrMsg("BasicRetrievalService.ResourceRejected") + (String)object;
            WorldWind.logger().log(Level.FINER, string);
        }
        object = new RetrievalTask(retriever, d);
        retriever.setSubmitTime(System.currentTimeMillis());
        if (this.activeTasks.contains(object) || this.executor.getQueue().contains(object)) {
            return null;
        }
        this.executor.execute((Runnable)object);
        return object;
    }

    public void setRetrieverPoolSize(int n) {
        if (n < 1) {
            String string = WorldWind.retrieveErrMsg("BasicRetrievalService.RetrieverPoolSizeIsLessThanOne");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.executor.setCorePoolSize(n);
        this.executor.setMaximumPoolSize(n);
    }

    public int getRetrieverPoolSize() {
        return this.executor.getCorePoolSize();
    }

    private boolean hasRetrievers() {
        Thread[] threadArray = new Thread[Thread.activeCount()];
        int n = Thread.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            if (!threadArray[i].getName().startsWith(RUNNING_THREAD_NAME_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveTasks() {
        return this.hasRetrievers();
    }

    public boolean isFull() {
        return this.executor.getQueue().size() >= this.queueSize;
    }

    public int getNumRetrieversPending() {
        return this.activeTasks.size() + this.executor.getQueue().size();
    }

    public boolean contains(Retriever retriever) {
        if (retriever == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RetrieverIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        RetrievalTask retrievalTask = new RetrievalTask(retriever, 0.0);
        return this.activeTasks.contains(retrievalTask) || this.executor.getQueue().contains(retrievalTask);
    }

    public double getProgress() {
        Object object;
        int n = 0;
        int n2 = 0;
        for (RetrievalTask runnable : this.activeTasks) {
            if (runnable.isDone()) continue;
            object = runnable.getRetriever();
            try {
                double retriever = object.getContentLength();
                if (!(retriever > 0.0)) continue;
                n = (int)((double)n + retriever);
                n2 += object.getContentLengthRead();
            }
            catch (Exception exception) {
                String exception2 = WorldWind.retrieveErrMsg("BasicRetrievalService.ExcptnRetrievingContentSizes") + (object.getName() != null ? object.getName() : "");
                WorldWind.logger().log(Level.FINE, exception2, exception);
            }
        }
        for (Runnable runnable : this.executor.getQueue()) {
            object = (RetrievalTask)runnable;
            Retriever retriever = ((RetrievalTask)object).getRetriever();
            try {
                double d = retriever.getContentLength();
                if (!(d > 0.0)) continue;
                n = (int)((double)n + d);
                n2 += retriever.getContentLengthRead();
            }
            catch (Exception exception) {
                String string = WorldWind.retrieveErrMsg("BasicRetrievalService.ExcptnRetrievingContentSizes") + (retriever.getName() != null ? retriever.getName() : "");
                WorldWind.logger().log(Level.FINE, string, exception);
            }
        }
        double d = n < 1 ? 0.0 : Math.min(100.0, 100.0 * (double)n2 / (double)n);
        return d;
    }

    private class RetrievalExecutor
    extends ThreadPoolExecutor {
        private static final long THREAD_TIMEOUT = 2L;
        private long staleRequestLimit;

        private RetrievalExecutor(int n, int n2) {
            super(n, n, 2L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(n2), new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    thread.setPriority(1);
                    thread.setUncaughtExceptionHandler(BasicRetrievalService.this);
                    return thread;
                }
            }, new ThreadPoolExecutor.DiscardPolicy(){

                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    RetrievalTask retrievalTask = (RetrievalTask)runnable;
                    String string = retrievalTask.getRetriever().getName();
                    String string2 = WorldWind.retrieveErrMsg("BasicRetrievalService.ResourceRejected") + string;
                    WorldWind.logger().log(Level.FINER, string2);
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            });
            this.staleRequestLimit = Configuration.getLongValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", 30000L);
        }

        protected void beforeExecute(Thread thread, Runnable runnable) {
            String string;
            WorldWind.logger().log(Level.FINEST, WorldWind.retrieveErrMsg("BasicRetrievalService.EnteringBeforeExecute"));
            if (thread == null) {
                String string2 = WorldWind.retrieveErrMsg("nullValue.ThreadIsNull");
                WorldWind.logger().log(Level.FINE, string2);
                throw new IllegalArgumentException(string2);
            }
            if (runnable == null) {
                String string3 = WorldWind.retrieveErrMsg("nullValue.RunnableIsNull");
                WorldWind.logger().log(Level.FINE, string3);
                throw new IllegalArgumentException(string3);
            }
            RetrievalTask retrievalTask = (RetrievalTask)runnable;
            retrievalTask.retriever.setBeginTime(System.currentTimeMillis());
            if (retrievalTask.retriever.getBeginTime() - retrievalTask.retriever.getSubmitTime() > this.staleRequestLimit) {
                string = WorldWind.retrieveErrMsg("BasicRetrievalService.CancellingTooOldRetrieval") + retrievalTask.getRetriever().getName();
                WorldWind.logger().log(Level.FINER, string);
                retrievalTask.cancel(true);
            }
            if (BasicRetrievalService.this.activeTasks.contains(retrievalTask)) {
                string = WorldWind.retrieveErrMsg("BasicRetrievalService.CancellingDuplicateRetrieval") + retrievalTask.getRetriever().getName();
                WorldWind.logger().log(Level.FINER, string);
                retrievalTask.cancel(true);
            }
            BasicRetrievalService.this.activeTasks.add(retrievalTask);
            thread.setName(RUNNING_THREAD_NAME_PREFIX + retrievalTask.getRetriever().getName());
            thread.setPriority(1);
            thread.setUncaughtExceptionHandler(BasicRetrievalService.this);
            super.beforeExecute(thread, runnable);
            WorldWind.logger().log(Level.FINEST, WorldWind.retrieveErrMsg("BasicRetrievalService.LeavingBeforeExecute"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            WorldWind.logger().log(Level.FINEST, WorldWind.retrieveErrMsg("BasicRetrievalService.EnteringAfterExecute"));
            if (runnable == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RunnableIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            super.afterExecute(runnable, throwable);
            RetrievalTask retrievalTask = (RetrievalTask)runnable;
            BasicRetrievalService.this.activeTasks.remove(retrievalTask);
            retrievalTask.retriever.setEndTime(System.currentTimeMillis());
            try {
                if (throwable != null) {
                    String string = WorldWind.retrieveErrMsg("BasicRetrievalService.ExceptionDuringRetrieval") + retrievalTask.getRetriever().getName();
                    WorldWind.logger().log(Level.FINE, string, throwable);
                }
                retrievalTask.get();
            }
            catch (ExecutionException executionException) {
                String string = WorldWind.retrieveErrMsg("BasicRetrievalService.ExecutionExceptionDuringRetrieval") + retrievalTask.getRetriever().getName();
                if (executionException.getCause() instanceof SocketTimeoutException) {
                    WorldWind.logger().log(Level.FINE, string + " " + executionException.getCause().getLocalizedMessage());
                } else {
                    WorldWind.logger().log(Level.FINE, string, executionException);
                }
            }
            catch (InterruptedException interruptedException) {
                String string = WorldWind.retrieveErrMsg("BasicRetrievalService.RetrievalOf_1") + retrievalTask.getRetriever().getName() + WorldWind.retrieveErrMsg("BasicRetrievalService.WasInterrupted_2");
                WorldWind.logger().log(Level.FINE, string, interruptedException);
            }
            catch (CancellationException cancellationException) {
                String string = WorldWind.retrieveErrMsg("BasicRetrievalService.RetrievalOf_1") + retrievalTask.getRetriever().getName() + WorldWind.retrieveErrMsg("BasicRetrievalService.WasCancelled_2");
                WorldWind.logger().log(Level.FINE, string);
            }
            finally {
                Thread.currentThread().setName(IDLE_THREAD_NAME_PREFIX);
                WorldWind.logger().log(Level.FINEST, WorldWind.retrieveErrMsg("BasicRetrievalService.LeavingAfterExecute"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RetrievalTask
    extends FutureTask<Retriever>
    implements RetrievalFuture,
    Comparable<RetrievalTask> {
        private Retriever retriever;
        private double priority;

        private RetrievalTask(Retriever retriever, double d) {
            super(retriever);
            this.retriever = retriever;
            this.priority = d;
        }

        public double getPriority() {
            return this.priority;
        }

        @Override
        public Retriever getRetriever() {
            return this.retriever;
        }

        @Override
        public void setException(Throwable throwable) {
            super.setException(throwable);
        }

        @Override
        public void run() {
            if (this.isDone() || this.isCancelled()) {
                return;
            }
            super.run();
        }

        @Override
        public int compareTo(RetrievalTask retrievalTask) {
            long l;
            long l2;
            long l3;
            if (retrievalTask == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RetrieverIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            if (this.priority > 0.0 && retrievalTask.priority > 0.0 && ((l3 = (l2 = System.currentTimeMillis()) - this.retriever.getSubmitTime()) - (l = l2 - retrievalTask.retriever.getSubmitTime())) / 500L != 0L) {
                return l3 < l ? -1 : 1;
            }
            return this.priority == retrievalTask.priority ? 0 : (this.priority < retrievalTask.priority ? -1 : 1);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RetrievalTask retrievalTask = (RetrievalTask)object;
            return this.retriever.equals(retrievalTask.retriever);
        }

        public int hashCode() {
            return this.retriever.getName().hashCode();
        }
    }
}

