/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.DrawContextImpl;
import gov.nasa.worldwind.FrameController;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.PickedObjectList;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import java.awt.Point;
import java.util.logging.Level;
import javax.media.opengl.GLContext;

public class BasicSceneController
extends WWObjectImpl
implements SceneController {
    private Model model;
    private View view;
    private FrameController frameController;
    private double verticalExaggeration = 1.0;
    private DrawContext dc = new DrawContextImpl();
    private PickedObjectList lastPickedObjects;
    private long frame = 0L;
    private long timebase = System.currentTimeMillis();
    private double framesPerSecond;
    private double frameTime;

    public BasicSceneController() {
        this.setFrameController((FrameController)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.FrameControllerClassName"));
        this.setVerticalExaggeration(Configuration.getDoubleValue("gov.nasa.worldwind.avkey.VerticalExaggeration", 1.0));
    }

    public FrameController getFrameController() {
        return this.frameController;
    }

    public Model getModel() {
        return this.model;
    }

    public View getView() {
        return this.view;
    }

    public void setFrameController(FrameController frameController) {
        if (frameController == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FrameControllerIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        FrameController frameController2 = this.frameController;
        this.frameController = frameController;
        this.firePropertyChange("gov.nasa.worldwind.avkey.FrameControllerObject", frameController2, frameController);
    }

    public void setModel(Model model) {
        if (this.model != null) {
            this.model.removePropertyChangeListener(this);
        }
        if (model != null) {
            model.addPropertyChangeListener(this);
        }
        Model model2 = this.model;
        this.model = model;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ModelObject", model2, model);
    }

    public void setView(View view) {
        if (this.view != null) {
            this.view.removePropertyChangeListener(this);
        }
        if (view != null) {
            view.addPropertyChangeListener(this);
        }
        View view2 = this.view;
        this.view = view;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", view2, view);
    }

    public void setVerticalExaggeration(double d) {
        Double d2 = this.verticalExaggeration;
        this.verticalExaggeration = d;
        this.firePropertyChange("gov.nasa.worldwind.avkey.VerticalExaggeration", d2, d);
    }

    public double getVerticalExaggeration() {
        return this.verticalExaggeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void repaint() {
        this.frameTime = System.currentTimeMillis();
        this.dc.initialize(GLContext.getCurrent());
        this.dc.setModel(this.model);
        this.dc.setView(this.view);
        this.dc.setVerticalExaggeration(this.verticalExaggeration);
        if (this.dc.getGLContext() == null) {
            String string = WorldWind.retrieveErrMsg("BasicSceneController.GLContextNullStartRedisplay");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        FrameController frameController = this.getFrameController();
        if (frameController == null) {
            String string = WorldWind.retrieveErrMsg("BasicSceneController.NoFrameControllerStartRepaint");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        try {
            try {
                frameController.initializeFrame(this.dc);
                frameController.drawFrame(this.dc);
            }
            catch (Throwable throwable) {
                String string = WorldWind.retrieveErrMsg("BasicSceneController.ExceptionDuringRendering");
                WorldWind.logger().log(Level.FINE, string, throwable);
                Object var5_6 = null;
                frameController.finalizeFrame(this.dc);
                ++this.frame;
                long l2 = System.currentTimeMillis();
                this.frameTime = (double)System.currentTimeMillis() - this.frameTime;
                if (l2 - this.timebase <= 5000L) return;
                this.framesPerSecond = (double)this.frame * 1000.0 / (double)(l2 - this.timebase);
                this.timebase = l2;
                this.frame = 0L;
                return;
            }
            Object var5_5 = null;
            frameController.finalizeFrame(this.dc);
            ++this.frame;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            frameController.finalizeFrame(this.dc);
            ++this.frame;
            long l = System.currentTimeMillis();
            this.frameTime = (double)System.currentTimeMillis() - this.frameTime;
            if (l - this.timebase <= 5000L) throw throwable;
            this.framesPerSecond = (double)this.frame * 1000.0 / (double)(l - this.timebase);
            this.timebase = l;
            this.frame = 0L;
            throw throwable;
        }
        long l = System.currentTimeMillis();
        this.frameTime = (double)System.currentTimeMillis() - this.frameTime;
        if (l - this.timebase <= 5000L) return;
        this.framesPerSecond = (double)this.frame * 1000.0 / (double)(l - this.timebase);
        this.timebase = l;
        this.frame = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PickedObjectList pick(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PickPoint");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.dc.getSurfaceGeometry() == null || this.dc.getVisibleSector() == null) {
            this.lastPickedObjects = null;
            return null;
        }
        this.dc.enablePickingMode();
        this.dc.initialize(GLContext.getCurrent());
        this.dc.setModel(this.model);
        this.dc.setView(this.view);
        this.dc.setVerticalExaggeration(this.verticalExaggeration);
        if (this.dc.getGLContext() == null) {
            String string = WorldWind.retrieveErrMsg("BasicSceneController.GLContextNullStartPick");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        FrameController frameController = this.getFrameController();
        if (frameController == null) {
            String string = WorldWind.retrieveErrMsg("BasicSceneController.NoFrameControllerStartPick");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        try {
            frameController.initializePicking(this.dc);
            frameController.pick(this.dc, point);
        }
        catch (Throwable throwable) {
            String string = WorldWind.retrieveErrMsg("BasicSceneController.ExceptionDuringPick");
            WorldWind.logger().log(Level.FINE, string, throwable);
        }
        finally {
            frameController.finalizePicking(this.dc);
            this.dc.disablePickingMode();
        }
        this.lastPickedObjects = new PickedObjectList(this.dc.getPickedObjects());
        return this.lastPickedObjects;
    }

    public PickedObjectList getPickedObjectList() {
        return this.lastPickedObjects;
    }

    public double getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public double getFrameTime() {
        return this.frameTime;
    }
}

