/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.AVList;
import gov.nasa.worldwind.AbsentResourceList;
import gov.nasa.worldwind.Tile;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.LatLon;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Level
implements Comparable<Level> {
    public static final String NUM_LEVELS = "gov.nasa.worldwind.Level.NumLevels";
    public static final String NUM_EMPTY_LEVELS = "gov.nasa.worldwind.Level.NumEmptyLevels";
    public static final String LEVEL_ZERO_TILE_DELTA = "gov.nasa.worldwind.Level.LevelZeroTileDelta";
    public static final String LEVEL_NUMBER = "gov.nasa.worldwind.Level.LevelNumberKey";
    public static final String LEVEL_NAME = "gov.nasa.worldwind.Level.LevelNameKey";
    public static final String TILE_DELTA = "gov.nasa.worldwind.Level.TileDeltaKey";
    public static final String TILE_WIDTH = "gov.nasa.worldwind.Level.TileWidthKey";
    public static final String TILE_HEIGHT = "gov.nasa.worldwind.Level.TileHeightKey";
    public static final String CACHE_NAME = "gov.nasa.worldwind.Level.CacheNameKey";
    public static final String SERVICE = "gov.nasa.worldwind.Level.ServiceURLKey";
    public static final String DATASET_NAME = "gov.nasa.worldwind.Level.DatasetNameKey";
    public static final String FORMAT_SUFFIX = "gov.nasa.worldwind.Level.FormatSuffixKey";
    public static final String EXPIRY_TIME = "gov.nasa.worldwind.Level.ExpiryTime";
    public static final String TILE_URL_BUILDER = "gov.nasa.worldwind.Level.TileURLBuilder";
    public static final String MAX_ABSENT_TILE_ATTEMPTS = "gov.nasa.worldwind.Level.MaxAbsentTileAttempts";
    public static final String MIN_ABSENT_TILE_CHECK_INTERVAL = "gov.nasa.worldwind.Level.MinAbsentTileCheckInterval";
    private final AVList params;
    private final int levelNumber;
    private final String levelName;
    private final LatLon tileDelta;
    private final int tileWidth;
    private final int tileHeight;
    private final String cacheName;
    private final String service;
    private final String dataset;
    private final String formatSuffix;
    private final double averageTexelSize;
    private final String path;
    private final TileURLBuilder urlbuilder;
    private long expiryTime = 0L;
    private final AbsentResourceList absentTiles;
    private static final int DEFAULT_MAX_ABSENT_TILE_ATTEMPTS = 2;
    private static final int DEFAULT_MIN_ABSENT_TILE_CHECK_INTERVAL = 10000;

    public Level(AVList aVList) {
        Integer n;
        if (aVList == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LayerParams");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.params = aVList.copy();
        String string = this.validate(aVList);
        if (string != null) {
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        String string2 = this.params.getStringValue(LEVEL_NAME);
        this.levelName = string2 != null ? string2 : "";
        this.levelNumber = (Integer)this.params.getValue(LEVEL_NUMBER);
        this.tileDelta = (LatLon)this.params.getValue(TILE_DELTA);
        this.tileWidth = (Integer)this.params.getValue(TILE_WIDTH);
        this.tileHeight = (Integer)this.params.getValue(TILE_HEIGHT);
        this.cacheName = this.params.getStringValue(CACHE_NAME);
        this.service = this.params.getStringValue(SERVICE);
        this.dataset = this.params.getStringValue(DATASET_NAME);
        this.formatSuffix = this.params.getStringValue(FORMAT_SUFFIX);
        this.urlbuilder = (TileURLBuilder)this.params.getValue(TILE_URL_BUILDER);
        double d = 0.5 * (double)(this.tileWidth + this.tileHeight);
        double d2 = 0.5 * (this.tileDelta.getLatitude().getRadians() + this.tileDelta.getLongitude().getRadians());
        this.averageTexelSize = d2 / d;
        this.path = this.cacheName + "/" + this.levelName;
        Integer n2 = (Integer)this.params.getValue(MAX_ABSENT_TILE_ATTEMPTS);
        if (n2 == null) {
            n2 = 2;
        }
        if ((n = (Integer)this.params.getValue(MIN_ABSENT_TILE_CHECK_INTERVAL)) == null) {
            n = 10000;
        }
        this.absentTiles = new AbsentResourceList(n2, n);
    }

    protected String validate(AVList aVList) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = aVList.getValue(LEVEL_NUMBER);
        if (object == null || !(object instanceof Integer) || (Integer)object < 0) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.levelNumber"));
        }
        if ((object = aVList.getValue(LEVEL_NAME)) == null || !(object instanceof String)) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.levelName"));
        }
        if ((object = aVList.getValue(TILE_WIDTH)) == null || !(object instanceof Integer) || (Integer)object < 0) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.tileWidth"));
        }
        if ((object = aVList.getValue(TILE_HEIGHT)) == null || !(object instanceof Integer) || (Integer)object < 0) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.tileHeight"));
        }
        if ((object = aVList.getValue(TILE_DELTA)) == null || !(object instanceof LatLon)) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.tileDelta"));
        }
        if ((object = aVList.getValue(CACHE_NAME)) == null || !(object instanceof String) || ((String)object).length() < 1) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.cacheFolder"));
        }
        if ((object = aVList.getValue(TILE_URL_BUILDER)) == null || !(object instanceof TileURLBuilder)) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.tileURLBuilder"));
        }
        if (!((object = aVList.getValue(EXPIRY_TIME)) == null || object instanceof Long && (Long)object >= 1L)) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.expiryTime"));
        }
        if (aVList.getStringValue(LEVEL_NAME).length() > 0) {
            object = aVList.getValue(SERVICE);
            if (object == null || !(object instanceof String) || ((String)object).length() < 1) {
                stringBuffer.append(WorldWind.retrieveErrMsg("term.service"));
            }
            if ((object = aVList.getValue(DATASET_NAME)) == null || !(object instanceof String) || ((String)object).length() < 1) {
                stringBuffer.append(WorldWind.retrieveErrMsg("term.datasetName"));
            }
            if ((object = aVList.getValue(FORMAT_SUFFIX)) == null || !(object instanceof String) || ((String)object).length() < 1) {
                stringBuffer.append(WorldWind.retrieveErrMsg("term.formatSuffix"));
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.insert(0, WorldWind.retrieveErrMsg("layers.LevelSet.InvalidLevelDescriptorFields")).toString();
    }

    public final AVList getParams() {
        return this.params;
    }

    public String getPath() {
        return this.path;
    }

    public final int getLevelNumber() {
        return this.levelNumber;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public LatLon getTileDelta() {
        return this.tileDelta;
    }

    public final int getTileWidth() {
        return this.tileWidth;
    }

    public final int getTileHeight() {
        return this.tileHeight;
    }

    public final String getFormatSuffix() {
        return this.formatSuffix;
    }

    public final String getService() {
        return this.service;
    }

    public final String getDataset() {
        return this.dataset;
    }

    public final String getCacheName() {
        return this.cacheName;
    }

    public final double getTexelSize(double d) {
        return d * this.averageTexelSize;
    }

    public final boolean isEmpty() {
        return this.levelName == null || this.levelName.equals("");
    }

    public final void markResourceAbsent(long l) {
        this.absentTiles.markResourceAbsent(l);
    }

    public final boolean isResourceAbsent(long l) {
        return this.absentTiles.isResourceAbsent(l);
    }

    public final void unmarkResourceAbsent(long l) {
        this.absentTiles.unmarkResourceAbsent(l);
    }

    public final long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    public URL getTileResourceURL(Tile tile) throws MalformedURLException {
        if (tile == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.TileIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.urlbuilder.getURL(tile);
    }

    @Override
    public int compareTo(Level level) {
        if (level == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LevelIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.levelNumber < level.levelNumber ? -1 : (this.levelNumber == level.levelNumber ? 0 : 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Level level = (Level)object;
        if (this.levelNumber != level.levelNumber) {
            return false;
        }
        if (this.tileHeight != level.tileHeight) {
            return false;
        }
        if (this.tileWidth != level.tileWidth) {
            return false;
        }
        if (this.cacheName != null ? !this.cacheName.equals(level.cacheName) : level.cacheName != null) {
            return false;
        }
        if (this.dataset != null ? !this.dataset.equals(level.dataset) : level.dataset != null) {
            return false;
        }
        if (this.formatSuffix != null ? !this.formatSuffix.equals(level.formatSuffix) : level.formatSuffix != null) {
            return false;
        }
        if (this.levelName != null ? !this.levelName.equals(level.levelName) : level.levelName != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(level.service) : level.service != null) {
            return false;
        }
        return !(this.tileDelta != null ? !this.tileDelta.equals(level.tileDelta) : level.tileDelta != null);
    }

    public int hashCode() {
        int n = this.levelNumber;
        n = 29 * n + (this.levelName != null ? this.levelName.hashCode() : 0);
        n = 29 * n + (this.tileDelta != null ? this.tileDelta.hashCode() : 0);
        n = 29 * n + this.tileWidth;
        n = 29 * n + this.tileHeight;
        n = 29 * n + (this.formatSuffix != null ? this.formatSuffix.hashCode() : 0);
        n = 29 * n + (this.service != null ? this.service.hashCode() : 0);
        n = 29 * n + (this.dataset != null ? this.dataset.hashCode() : 0);
        n = 29 * n + (this.cacheName != null ? this.cacheName.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.path;
    }

    public static interface TileURLBuilder {
        public URL getURL(Tile var1) throws MalformedURLException;
    }
}

