/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.AVList;
import gov.nasa.worldwind.Level;
import gov.nasa.worldwind.Tile;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelSet
extends WWObjectImpl {
    private final Sector sector;
    private final LatLon levelZeroTileDelta;
    private final int numLevelZeroColumns;
    private final ArrayList<Level> levels = new ArrayList();

    public LevelSet(AVList aVList) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = aVList.getValue("gov.nasa.worldwind.Level.LevelZeroTileDelta");
        if (object == null || !(object instanceof LatLon)) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.tileDelta"));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object instanceof Sector)) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.sector"));
        }
        int n = 0;
        object = aVList.getValue("gov.nasa.worldwind.Level.NumLevels");
        if (object == null || !(object instanceof Integer) || (n = ((Integer)object).intValue()) < 1) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.numLevels"));
        }
        int n2 = 0;
        object = aVList.getValue("gov.nasa.worldwind.Level.NumEmptyLevels");
        if (object == null || !(object instanceof Integer) || (n2 = ((Integer)object).intValue()) < 0) {
            stringBuffer.append(WorldWind.retrieveErrMsg("term.numEMptyLevels"));
        }
        if (stringBuffer.length() > 0) {
            String string = WorldWind.retrieveErrMsg("layers.LevelSet.InvalidLevelDescriptorFields") + " " + stringBuffer.toString();
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.levelZeroTileDelta = (LatLon)aVList.getValue("gov.nasa.worldwind.Level.LevelZeroTileDelta");
        this.sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        Level.TileURLBuilder tileURLBuilder = (Level.TileURLBuilder)(aVList = aVList.copy()).getValue("gov.nasa.worldwind.Level.TileURLBuilder");
        if (tileURLBuilder == null) {
            aVList.setValue("gov.nasa.worldwind.Level.TileURLBuilder", new Level.TileURLBuilder(){

                public URL getURL(Tile tile) throws MalformedURLException {
                    StringBuffer stringBuffer = new StringBuffer(tile.getLevel().getService());
                    if (stringBuffer.lastIndexOf("?") != stringBuffer.length() - 1) {
                        stringBuffer.append("?");
                    }
                    stringBuffer.append("T=");
                    stringBuffer.append(tile.getLevel().getDataset());
                    stringBuffer.append("&L=");
                    stringBuffer.append(tile.getLevel().getLevelName());
                    stringBuffer.append("&X=");
                    stringBuffer.append(tile.getColumn());
                    stringBuffer.append("&Y=");
                    stringBuffer.append(tile.getRow());
                    return new URL(stringBuffer.toString());
                }
            });
        }
        for (int i = 0; i < n; ++i) {
            aVList.setValue("gov.nasa.worldwind.Level.LevelNameKey", i < n2 ? "" : Integer.toString(i - n2));
            aVList.setValue("gov.nasa.worldwind.Level.LevelNumberKey", i);
            Angle angle = this.levelZeroTileDelta.getLatitude().divide(Math.pow(2.0, i));
            Angle angle2 = this.levelZeroTileDelta.getLongitude().divide(Math.pow(2.0, i));
            aVList.setValue("gov.nasa.worldwind.Level.TileDeltaKey", new LatLon(angle, angle2));
            this.levels.add(new Level(aVList));
        }
        this.numLevelZeroColumns = (int)Math.round(this.sector.getDeltaLon().divide(this.levelZeroTileDelta.getLongitude()));
    }

    public LevelSet(LevelSet levelSet) {
        if (levelSet == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LevelSetIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.levelZeroTileDelta = levelSet.levelZeroTileDelta;
        this.sector = levelSet.sector;
        this.numLevelZeroColumns = levelSet.numLevelZeroColumns;
        for (Level level : levelSet.levels) {
            this.levels.add(level);
        }
    }

    public final Sector getSector() {
        return this.sector;
    }

    public final LatLon getLevelZeroTileDelta() {
        return this.levelZeroTileDelta;
    }

    public final ArrayList<Level> getLevels() {
        return this.levels;
    }

    public final Level getLevel(int n) {
        return n >= 0 && n < this.levels.size() ? this.levels.get(n) : null;
    }

    public final int getNumLevels() {
        return this.levels.size();
    }

    public final Level getFirstLevel() {
        return this.getLevel(0);
    }

    public final Level getLastLevel() {
        return this.getLevel(this.getNumLevels() - 1);
    }

    public final boolean isFinalLevel(int n) {
        return n == this.getNumLevels() - 1;
    }

    public final boolean isLevelEmpty(int n) {
        return this.levels.get(n).isEmpty();
    }

    private int numColumnsInLevel(Level level) {
        int n = level.getLevelNumber() - this.getFirstLevel().getLevelNumber();
        double d = Math.pow(2.0, n);
        return (int)(d * (double)this.numLevelZeroColumns);
    }

    private long getTileNumber(Tile tile) {
        return tile.getRow() * this.numColumnsInLevel(tile.getLevel()) + tile.getColumn();
    }

    public final void markResourceAbsent(Tile tile) {
        if (tile == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.TileIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        tile.getLevel().markResourceAbsent(this.getTileNumber(tile));
    }

    public final boolean isResourceAbsent(Tile tile) {
        if (tile == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.TileIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (tile.getLevel().isEmpty()) {
            return true;
        }
        int n = tile.getRow() * this.numColumnsInLevel(tile.getLevel()) + tile.getColumn();
        return tile.getLevel().isResourceAbsent(n);
    }

    public final void unmarkResourceAbsent(Tile tile) {
        if (tile == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.TileIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        tile.getLevel().unmarkResourceAbsent(this.getTileNumber(tile));
    }
}

