/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Layer;
import gov.nasa.worldwind.PickedObject;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Position;
import java.awt.Color;
import java.awt.Point;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.logging.Level;
import javax.media.opengl.GL;

public class PickSupport {
    private HashMap<Integer, PickedObject> pickableObjects = new HashMap();

    public void clearPickList() {
        this.pickableObjects.clear();
    }

    public void addPickableObject(int n, Object object, Position position, boolean bl) {
        this.pickableObjects.put(n, new PickedObject(n, object, position, bl));
    }

    public void addPickableObject(int n, Object object) {
        this.pickableObjects.put(n, new PickedObject(n, object));
    }

    public void addPickableObject(int n, PickedObject pickedObject) {
        this.pickableObjects.put(n, pickedObject);
    }

    public PickedObject getTopObject(DrawContext drawContext, Point point, Layer layer) {
        if (this.pickableObjects.isEmpty()) {
            return null;
        }
        int n = this.getTopColor(drawContext, point);
        if (n == drawContext.getClearColor().getRGB()) {
            return null;
        }
        PickedObject pickedObject = this.pickableObjects.get(n);
        if (pickedObject == null) {
            return null;
        }
        if (layer != null) {
            pickedObject.setParentLayer(layer);
        }
        return pickedObject;
    }

    public void resolvePick(DrawContext drawContext, Point point, Layer layer) {
        PickedObject pickedObject = this.getTopObject(drawContext, point, layer);
        if (pickedObject != null) {
            drawContext.addPickedObject(pickedObject);
        }
        this.clearPickList();
    }

    public int getTopColor(DrawContext drawContext, Point point) {
        GL gL = drawContext.getGL();
        int[] nArray = new int[4];
        gL.glGetIntegerv(2978, nArray, 0);
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(3);
        gL.glReadPixels(point.x, nArray[3] - point.y, 1, 1, 6407, 5121, byteBuffer);
        Color color = null;
        try {
            color = new Color(byteBuffer.get(0) & 0xFF, byteBuffer.get(1) & 0xFF, byteBuffer.get(2) & 0xFF, 0);
        }
        catch (Exception exception) {
            String string = WorldWind.retrieveErrMsg("layers.InvalidPickColorRead");
            WorldWind.logger().log(Level.FINE, string);
        }
        return color != null ? color.getRGB() : 0;
    }

    public void beginPicking(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glPushAttrib(8192);
        gL.glDisable(3024);
        gL.glDisable(2896);
        gL.glDisable(2912);
        gL.glDisable(3042);
        gL.glDisable(3553);
    }

    public void endPicking(DrawContext drawContext) {
        drawContext.getGL().glPopAttrib();
    }
}

