/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.PlaceName;
import gov.nasa.worldwind.SectorGeometryList;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Point;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceNameRenderer
implements Disposable {
    private static final Font defaultFont = Font.decode("Arial-12-PLAIN");
    private static final Color defaultColor = Color.white;
    private final Map<Font, TextRenderer> textRenderers = new HashMap<Font, TextRenderer>();
    private TextRenderer lastTextRenderer = null;
    private final GLU glu = new GLU();
    private final int[] viewportArray = new int[4];
    private final float[] compArray = new float[4];

    @Override
    public void dispose() {
        for (TextRenderer textRenderer : this.textRenderers.values()) {
            if (textRenderer == null) continue;
            textRenderer.dispose();
        }
    }

    public void render(DrawContext drawContext, Iterator<PlaceName> iterator, boolean bl) {
        this.drawMany(drawContext, iterator, bl);
    }

    public void render(DrawContext drawContext, PlaceName placeName, Point point, boolean bl) {
        if (!PlaceNameRenderer.isNameValid(placeName, false)) {
            return;
        }
        this.drawOne(drawContext, placeName, point, bl);
    }

    private void drawMany(DrawContext drawContext, Iterator<PlaceName> iterator, boolean bl) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (iterator == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.Iterator");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!iterator.hasNext()) {
            return;
        }
        Frustum frustum = drawContext.getView().getFrustumInModelCoordinates();
        double d = drawContext.getView().computeHorizonDistance();
        this.beginDrawNames(drawContext, bl);
        while (iterator.hasNext()) {
            double d2;
            Point point;
            PlaceName placeName = iterator.next();
            if (!PlaceNameRenderer.isNameValid(placeName, true) || !placeName.isVisible()) continue;
            Angle angle = placeName.getPosition().getLatitude();
            Angle angle2 = placeName.getPosition().getLongitude();
            if (!drawContext.getVisibleSector().contains(angle, angle2) || (point = sectorGeometryList.getSurfacePoint(angle, angle2, placeName.getPosition().getElevation())) == null || (d2 = drawContext.getView().getEyePoint().distanceTo(point)) > d || !frustum.contains(point)) continue;
            this.drawName(drawContext, placeName, point, bl);
        }
        this.endDrawNames(drawContext);
    }

    private void drawOne(DrawContext drawContext, PlaceName placeName, Point point, boolean bl) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView() == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ViewIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (!placeName.isVisible()) {
            return;
        }
        if (point == null) {
            if (placeName.getPosition() == null) {
                return;
            }
            Angle angle = placeName.getPosition().getLatitude();
            Angle angle2 = placeName.getPosition().getLongitude();
            if (!drawContext.getVisibleSector().contains(angle, angle2)) {
                return;
            }
            point = sectorGeometryList.getSurfacePoint(angle, angle2, placeName.getPosition().getElevation());
            if (point == null) {
                return;
            }
        }
        double d = drawContext.getView().computeHorizonDistance();
        double d2 = drawContext.getView().getEyePoint().distanceTo(point);
        if (d2 > d) {
            return;
        }
        if (!drawContext.getView().getFrustumInModelCoordinates().contains(point)) {
            return;
        }
        this.beginDrawNames(drawContext, bl);
        this.drawName(drawContext, placeName, point, bl);
        this.endDrawNames(drawContext);
    }

    private static boolean isNameValid(PlaceName placeName, boolean bl) {
        if (placeName == null || placeName.getText() == null) {
            return false;
        }
        return !bl || placeName.getPosition() != null;
    }

    private void beginDrawNames(DrawContext drawContext, boolean bl) {
        GL gL = drawContext.getGL();
        int n = 0x7001 | (bl ? 2304 : 0);
        gL.glPushAttrib(n);
        gL.glGetIntegerv(2978, this.viewportArray, 0);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        this.glu.gluOrtho2D(0.0, this.viewportArray[2], 0.0, this.viewportArray[3]);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5890);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        if (bl) {
            gL.glEnable(2929);
            gL.glDepthFunc(513);
            gL.glDepthMask(false);
        } else {
            gL.glDisable(2929);
        }
        gL.glDisable(2884);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.001f);
    }

    private void endDrawNames(DrawContext drawContext) {
        if (this.lastTextRenderer != null) {
            this.lastTextRenderer.end3DRendering();
            this.lastTextRenderer = null;
        }
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    private Point drawName(DrawContext drawContext, PlaceName placeName, Point point, boolean bl) {
        TextRenderer textRenderer;
        Font font;
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            return null;
        }
        String string = placeName.getText();
        if (string == null) {
            return null;
        }
        Point point2 = drawContext.getView().project(point);
        if (point2 == null) {
            return null;
        }
        if (bl) {
            this.setDepthFunc(drawContext, point2);
        }
        if ((font = placeName.getFont()) == null) {
            font = defaultFont;
        }
        if ((textRenderer = this.textRenderers.get(font)) == null) {
            textRenderer = this.initializeTextRenderer(font);
        }
        if (textRenderer != this.lastTextRenderer) {
            if (this.lastTextRenderer != null) {
                this.lastTextRenderer.end3DRendering();
            }
            textRenderer.begin3DRendering();
            this.lastTextRenderer = textRenderer;
        }
        Rectangle2D rectangle2D = textRenderer.getBounds(string);
        int n = (int)(point2.x() - rectangle2D.getWidth() / 2.0);
        int n2 = (int)point2.y();
        Color color = placeName.getColor();
        if (color == null) {
            color = defaultColor;
        }
        this.setBackgroundColor(textRenderer, color);
        textRenderer.draw(string, n + 1, n2 - 1);
        textRenderer.setColor(color);
        textRenderer.draw(string, n, n2);
        return point2;
    }

    private void setDepthFunc(DrawContext drawContext, Point point) {
        double d = point.z() - 0.00391006472;
        d = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
        drawContext.getGL().glDepthRange(d, d);
    }

    private void setBackgroundColor(TextRenderer textRenderer, Color color) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.compArray);
        if ((double)this.compArray[2] > 0.5) {
            textRenderer.setColor(0.0f, 0.0f, 0.0f, 0.7f);
        } else {
            textRenderer.setColor(1.0f, 1.0f, 1.0f, 0.7f);
        }
    }

    private TextRenderer initializeTextRenderer(Font font) {
        TextRenderer textRenderer = new TextRenderer(font, true, true);
        TextRenderer textRenderer2 = this.textRenderers.put(font, textRenderer);
        if (textRenderer2 != null) {
            textRenderer2.dispose();
        }
        return textRenderer;
    }

    public String toString() {
        return WorldWind.retrieveErrMsg("layers.PlaceNameLayer.Name");
    }
}

