/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.PlaceNameService;
import gov.nasa.worldwind.WorldWind;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class PlaceNameServiceSet {
    private final List<PlaceNameService> serviceList = new LinkedList<PlaceNameService>();

    public boolean addService(PlaceNameService placeNameService, boolean bl) {
        if (placeNameService == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PlaceNameServiceIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < this.serviceList.size(); ++i) {
            PlaceNameService placeNameService2 = this.serviceList.get(i);
            if (!placeNameService.getService().equals(placeNameService2.getService()) || !placeNameService.getDataset().equals(placeNameService2.getDataset())) continue;
            if (bl) {
                this.serviceList.set(i, placeNameService);
                return true;
            }
            return false;
        }
        this.serviceList.add(placeNameService);
        return true;
    }

    public final PlaceNameServiceSet deepCopy() {
        PlaceNameServiceSet placeNameServiceSet = new PlaceNameServiceSet();
        for (int i = 0; i < this.serviceList.size(); ++i) {
            placeNameServiceSet.serviceList.add(i, this.serviceList.get(i).deepCopy());
        }
        return placeNameServiceSet;
    }

    public final int getServiceCount() {
        return this.serviceList.size();
    }

    public final PlaceNameService getService(int n) {
        return this.serviceList.get(n);
    }
}

