/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.PickSupport;
import gov.nasa.worldwind.PickedObject;
import gov.nasa.worldwind.SectorGeometry;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectorGeometryList
extends ArrayList<SectorGeometry> {
    private PickSupport pickSupport = new PickSupport();

    public SectorGeometryList() {
    }

    public SectorGeometryList(SectorGeometryList sectorGeometryList) {
        super(sectorGeometryList);
    }

    public List<SectorGeometry> getIntersectingSectors(Sector sector) {
        ArrayList<SectorGeometry> arrayList = null;
        for (SectorGeometry sectorGeometry : this) {
            if (!sectorGeometry.getSector().intersects(sector)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<SectorGeometry>();
            }
            arrayList.add(sectorGeometry);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pick(DrawContext drawContext, java.awt.Point point) {
        this.pickSupport.clearPickList();
        this.pickSupport.beginPicking(drawContext);
        GL gL = drawContext.getGL();
        gL.glPushAttrib(8513);
        gL.glEnable(2929);
        gL.glShadeModel(7424);
        gL.glDisable(2884);
        try {
            SectorGeometry sectorGeometry2;
            for (SectorGeometry sectorGeometry2 : this) {
                Color color = drawContext.getUniquePickColor();
                drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                sectorGeometry2.render(drawContext);
                this.pickSupport.addPickableObject(color.getRGB(), sectorGeometry2, Position.ZERO, true);
            }
            PickedObject pickedObject = this.pickSupport.getTopObject(drawContext, point, null);
            if (pickedObject == null || pickedObject.getObject() == null) {
                return;
            }
            sectorGeometry2 = (SectorGeometry)pickedObject.getObject();
            gL.glDepthFunc(515);
            sectorGeometry2.pick(drawContext, point);
        }
        finally {
            gL.glPopAttrib();
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.clearPickList();
        }
    }

    public Point getSurfacePoint(Position position) {
        return this.getSurfacePoint(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    public Point getSurfacePoint(Angle angle, Angle angle2) {
        return this.getSurfacePoint(angle, angle2, 0.0);
    }

    public Point getSurfacePoint(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatLonIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        for (SectorGeometry sectorGeometry : this) {
            Point point;
            if (!sectorGeometry.getSector().contains(angle, angle2) || (point = sectorGeometry.getSurfacePoint(angle, angle2, d)) == null) continue;
            return point;
        }
        return null;
    }
}

