/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.PickedObject;
import gov.nasa.worldwind.PickedObjectList;
import gov.nasa.worldwind.WorldWind;
import java.awt.event.MouseEvent;
import java.util.EventObject;

public class SelectEvent
extends EventObject {
    public static final String LEFT_CLICK = "gov.nasa.worldwind.SelectEvent.LeftClick";
    public static final String LEFT_DOUBLE_CLICK = "gov.nasa.worldwind.SelectEvent.LeftDoubleClick";
    public static final String RIGHT_CLICK = "gov.nasa.worldwind.SelectEvent.RightClick";
    public static final String HOVER = "gov.nasa.worldwind.SelectEvent.Hover";
    public static final String ROLLOVER = "gov.nasa.worldwind.SelectEvent.Rollover";
    public static final String DRAG = "gov.nasa.worldwind.SelectEvent.Drag";
    private final String eventAction;
    private final MouseEvent mouseEvent;
    private final PickedObjectList pickedObjects;

    public SelectEvent(Object object, String string, MouseEvent mouseEvent, PickedObjectList pickedObjectList) {
        super(object);
        this.eventAction = string;
        this.mouseEvent = mouseEvent;
        this.pickedObjects = pickedObjectList;
    }

    public String getEventAction() {
        return this.eventAction != null ? this.eventAction : "gov.nasa.worldwind.SelectEvent.UnknownEventAction";
    }

    public MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    public boolean hasObjects() {
        return this.pickedObjects != null && this.pickedObjects.size() > 0;
    }

    public PickedObjectList getObjects() {
        return this.pickedObjects;
    }

    public PickedObject getTopPickedObject() {
        return this.hasObjects() ? this.pickedObjects.getTopObject() : null;
    }

    public Object getTopObject() {
        PickedObject pickedObject = this.getTopPickedObject();
        return pickedObject != null ? pickedObject.getObject() : null;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.eventAction != null ? this.eventAction : WorldWind.retrieveErrMsg("generic.unknown");
    }
}

