/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Layer;
import gov.nasa.worldwind.Material;
import gov.nasa.worldwind.SectorGeometryList;
import gov.nasa.worldwind.TrackPoint;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.PolarPoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackRenderer
implements Disposable {
    private int lowerLimit = 0;
    private int upperLimit = Integer.MAX_VALUE;
    private double markerPixels = 10.0;
    private double minMarkerSize = 5.0;
    private double markerElevation = 10.0;
    private boolean overrideMarkerElevation = false;
    private Material material = Material.WHITE;
    private String iconFilePath;
    private final Shape SPHERE = new Sphere();
    private final Shape CONE = new Cone();
    private final Shape CYLINDER = new Cylinder();
    private Shape shape = this.SPHERE;

    @Override
    public void dispose() {
        this.CONE.dispose();
        this.CYLINDER.dispose();
        this.SPHERE.dispose();
    }

    public double getMarkerPixels() {
        return this.markerPixels;
    }

    public void setMarkerPixels(double d) {
        this.markerPixels = d;
    }

    public double getMinMarkerSize() {
        return this.minMarkerSize;
    }

    public void setMinMarkerSize(double d) {
        this.minMarkerSize = d;
    }

    public double getMarkerElevation() {
        return this.markerElevation;
    }

    public void setMarkerElevation(double d) {
        this.markerElevation = d;
    }

    public boolean isOverrideMarkerElevation() {
        return this.overrideMarkerElevation;
    }

    public void setOverrideMarkerElevation(boolean bl) {
        this.overrideMarkerElevation = bl;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        if (material == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.MaterialIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.material = material;
    }

    public String getIconFilePath() {
        return this.iconFilePath;
    }

    public void setIconFilePath(String string) {
        this.iconFilePath = string;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(int n) {
        this.lowerLimit = n;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(int n) {
        this.upperLimit = n;
    }

    public void setShapeType(String string) {
        this.shape = string.equalsIgnoreCase("Cone") ? this.CONE : (string.equalsIgnoreCase("Cylinder") ? this.CYLINDER : this.SPHERE);
    }

    public void pick(DrawContext drawContext, Iterator<TrackPoint> iterator, java.awt.Point point, Layer layer) {
    }

    public Point render(DrawContext drawContext, Iterator<TrackPoint> iterator) {
        return this.draw(drawContext, iterator);
    }

    private Point draw(DrawContext drawContext, Iterator<TrackPoint> iterator) {
        Object object;
        Object object2;
        if (drawContext.getVisibleSector() == null) {
            return null;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return null;
        }
        if (!this.shape.isInitialized) {
            this.shape.initialize(drawContext);
        }
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (n >= this.lowerLimit && n <= this.upperLimit && (object = this.computeSurfacePoint(drawContext, (TrackPoint)object2)) != null) {
                arrayList.add(object);
            }
            if (++n < this.upperLimit) continue;
            break;
        }
        if (arrayList.size() < 1) {
            return null;
        }
        object = object2 = (Point)arrayList.get(0);
        this.begin(drawContext);
        Object object3 = null;
        double d = this.computeMarkerRadius(drawContext, (Point)object2);
        this.shape.render(drawContext, (Point)object2, d);
        for (Point point : arrayList) {
            double d2;
            if (object3 == null) {
                object3 = object2;
                continue;
            }
            d = this.computeMarkerRadius(drawContext, point);
            double d3 = point.distanceTo((Point)object3);
            if (!(d3 > (d2 = 4.0 * d))) continue;
            if (!drawContext.isPickingMode()) {
                this.shape.render(drawContext, point, d);
            }
            object3 = point;
            object = point;
        }
        this.end(drawContext);
        object3 = (Point)arrayList.get(arrayList.size() - 1);
        return object3 != null ? object3 : object;
    }

    private Point computeSurfacePoint(DrawContext drawContext, TrackPoint trackPoint) {
        return drawContext.getSurfaceGeometry().getSurfacePoint(Angle.fromDegrees(trackPoint.getLatitude()), Angle.fromDegrees(trackPoint.getLongitude()), this.overrideMarkerElevation ? this.markerElevation : trackPoint.getElevation());
    }

    private double computeMarkerRadius(DrawContext drawContext, Point point) {
        double d = point.distanceTo(drawContext.getView().getEyePoint());
        double d2 = this.markerPixels * drawContext.getView().computePixelSizeAtDistance(d);
        if (d2 < this.minMarkerSize) {
            d2 = this.minMarkerSize;
        }
        return d2;
    }

    private void begin(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        Point point = drawContext.getView().getEyePoint();
        gL.glPushAttrib(274497);
        gL.glDisable(3553);
        float[] fArray = new float[]{(float)(point.x() * 2.0), (float)(point.y() / 2.0), (float)point.z(), 0.0f};
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] fArray4 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        this.material.apply(gL, 1028);
        gL.glLightfv(16385, 4611, fArray, 0);
        gL.glLightfv(16385, 4609, fArray2, 0);
        gL.glLightfv(16385, 4608, fArray3, 0);
        gL.glLightfv(16385, 4610, fArray4, 0);
        gL.glDisable(16384);
        gL.glEnable(16385);
        gL.glEnable(2896);
        gL.glEnable(2977);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
    }

    private void end(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glDisable(16385);
        gL.glEnable(16384);
        gL.glDisable(2896);
        gL.glDisable(2977);
        gL.glPopAttrib();
    }

    private static class Cylinder
    extends Shape {
        private Cylinder() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            int n = 30;
            int n2 = 30;
            int n3 = 2;
            drawContext.getGL().glNewList(this.objectId, 4864);
            drawContext.getGLU().gluCylinder(this.quadric, 1.0, 1.0, 2.0, n, (int)(2.0 * Math.sqrt(n2) + 1.0));
            drawContext.getGLU().gluDisk(this.quadric, 0.0, 1.0, n, n3);
            drawContext.getGL().glTranslated(0.0, 0.0, 2.0);
            drawContext.getGLU().gluDisk(this.quadric, 0.0, 1.0, n, n3);
            drawContext.getGL().glTranslated(0.0, 0.0, -2.0);
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Point point, double d) {
            PolarPoint polarPoint = PolarPoint.fromCartesian(point);
            drawContext.getGL().glLoadIdentity();
            drawContext.getGL().glScaled(d, d, d);
            drawContext.getGL().glRotated(polarPoint.getLongitude().getDegrees(), 0.0, 1.0, 0.0);
            drawContext.getGL().glRotated(Math.abs(polarPoint.getLatitude().getDegrees()), Math.signum(polarPoint.getLatitude().getDegrees()) * -1.0, 0.0, 0.0);
            drawContext.getGL().glCallList(this.objectId);
        }
    }

    private static class Cone
    extends Shape {
        private Cone() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            int n = 30;
            int n2 = 30;
            int n3 = 2;
            drawContext.getGL().glNewList(this.objectId, 4864);
            drawContext.getGLU().gluCylinder(this.quadric, 1.0, 0.0, 2.0, n, (int)(2.0 * Math.sqrt(n2) + 1.0));
            drawContext.getGLU().gluDisk(this.quadric, 0.0, 1.0, n, n3);
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Point point, double d) {
            PolarPoint polarPoint = PolarPoint.fromCartesian(point);
            drawContext.getGL().glLoadIdentity();
            drawContext.getGL().glScaled(d, d, d);
            drawContext.getGL().glRotated(polarPoint.getLongitude().getDegrees(), 0.0, 1.0, 0.0);
            drawContext.getGL().glRotated(Math.abs(polarPoint.getLatitude().getDegrees()), Math.signum(polarPoint.getLatitude().getDegrees()) * -1.0, 0.0, 0.0);
            drawContext.getGL().glCallList(this.objectId);
        }
    }

    private static class Sphere
    extends Shape {
        private Sphere() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            double d = 1.0;
            int n = 36;
            int n2 = 18;
            drawContext.getGL().glNewList(this.objectId, 4864);
            drawContext.getGLU().gluSphere(this.quadric, d, n, n2);
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Point point, double d) {
            drawContext.getGL().glScaled(d, d, d);
            drawContext.getGL().glCallList(this.objectId);
        }
    }

    private static abstract class Shape {
        protected int objectId;
        protected GLUquadric quadric;
        protected boolean isInitialized = false;

        private Shape() {
        }

        protected abstract void doRender(DrawContext var1, Point var2, double var3);

        protected void initialize(DrawContext drawContext) {
            this.objectId = drawContext.getGL().glGenLists(1);
            this.quadric = drawContext.getGLU().gluNewQuadric();
            drawContext.getGLU().gluQuadricDrawStyle(this.quadric, 100012);
            drawContext.getGLU().gluQuadricNormals(this.quadric, 100000);
            drawContext.getGLU().gluQuadricOrientation(this.quadric, 100020);
            drawContext.getGLU().gluQuadricTexture(this.quadric, false);
        }

        private void dispose() {
            if (this.isInitialized) {
                GLU gLU = new GLU();
                gLU.gluDeleteQuadric(this.quadric);
            }
        }

        private void render(DrawContext drawContext, Point point, double d) {
            drawContext.getView().pushReferenceCenter(drawContext, point);
            this.doRender(drawContext, point, d);
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }
}

