/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.WorldWind;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class WWIO {
    public static boolean saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        if (byteBuffer == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.BufferNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (file == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        FileOutputStream fileOutputStream = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        int n = 0;
        try {
            fileOutputStream = new FileOutputStream(file);
            abstractInterruptibleChannel = fileOutputStream.getChannel();
            FileLock fileLock = ((FileChannel)abstractInterruptibleChannel).tryLock();
            if (fileLock == null) {
                String string = WorldWind.retrieveErrMsg("WWIO.UnableToAcquireLockFor") + file.getPath();
                WorldWind.logger().log(Level.FINER, string);
                boolean bl = false;
                return bl;
            }
            byteBuffer.rewind();
            while (byteBuffer.hasRemaining()) {
                n += ((FileChannel)abstractInterruptibleChannel).write(byteBuffer);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            String string = WorldWind.retrieveErrMsg("WWIO.ErrorSavingBufferTo") + file.getPath();
            WorldWind.logger().log(Level.FINE, string, iOException);
            if (n > 0) {
                file.delete();
            }
            throw iOException;
        }
        finally {
            try {
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                } else if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                String string = WorldWind.retrieveErrMsg("WWIO.ErrorTryingToClose") + file.getPath();
                WorldWind.logger().log(Level.FINE, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappedByteBuffer mapFile(File file) throws IOException {
        if (file == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            MappedByteBuffer mappedByteBuffer = fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            return mappedByteBuffer;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readURLContentToBuffer(URL uRL) throws IOException {
        ByteBuffer byteBuffer;
        if (uRL == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.URLIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        InputStream inputStream = uRL.openStream();
        try {
            int n;
            URLConnection uRLConnection = uRL.openConnection();
            int n2 = uRLConnection.getContentLength();
            byteBuffer = ByteBuffer.allocateDirect(n2);
            byte[] byArray = new byte[n2];
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                byteBuffer.put(byArray, 0, n);
            } while (byteBuffer.hasRemaining() && n >= 0);
            byteBuffer.flip();
            byteBuffer.rewind();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readFileToBuffer(File file) throws IOException {
        if (file == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
            int n = 0;
            while (n >= 0 && byteBuffer.hasRemaining()) {
                n = fileChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readZipEntryToBuffer(File file, String string) throws IOException {
        if (file == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.FileIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry;
            ZipFile zipFile = new ZipFile(file);
            if (zipFile.size() < 1) {
                String string3 = WorldWind.retrieveErrMsg("WWIO.ZipFileIsEmpty") + file.getPath();
                WorldWind.logger().log(Level.FINE, string3);
                throw new IOException(string3);
            }
            if (string != null) {
                zipEntry = zipFile.getEntry(string);
                if (zipEntry == null) {
                    String string4 = WorldWind.retrieveErrMsg("WWIO.ZipFileEntryNIF") + string + WorldWind.retrieveErrMsg("punctuation.space") + file.getPath();
                    WorldWind.logger().log(Level.FINE, string4);
                    throw new IOException(string4);
                }
            } else {
                zipEntry = zipFile.entries().nextElement();
            }
            inputStream = zipFile.getInputStream(zipEntry);
            ByteBuffer byteBuffer = null;
            if (zipEntry.getSize() > 0L) {
                byteBuffer = WWIO.transferStreamToByteBuffer(inputStream, (int)zipEntry.getSize());
                byteBuffer.flip();
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static ByteBuffer transferStreamToByteBuffer(InputStream inputStream, int n) throws IOException {
        if (inputStream == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.InputStreamIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            String string = WorldWind.retrieveErrMsg("WWIO.NumberBytesTransferLessThanOne");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[n];
        while (n3 >= 0 && n - n2 > 0) {
            n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 <= 0) continue;
            n2 += n3;
        }
        return ByteBuffer.wrap(byArray);
    }

    public static String levelRowColumnPath(StringBuffer stringBuffer, String string, int n, int n2, String string2) {
        StringBuffer stringBuffer2 = stringBuffer;
        if (stringBuffer2 == null) {
            stringBuffer2 = new StringBuffer();
        }
        if (string != null) {
            stringBuffer2.append(string);
        }
        String string3 = "/" + Integer.toString(n);
        stringBuffer2.append(string3);
        stringBuffer2.append(string3);
        stringBuffer2.append("_");
        stringBuffer2.append(Integer.toString(n2));
        if (string2 != null) {
            if (!string2.startsWith(".")) {
                stringBuffer2.append(".");
            }
            stringBuffer2.append(string2);
        }
        return stringBuffer2.toString();
    }

    public static String replaceSuffix(String string, String string2) {
        if (string == null) {
            String string3 = WorldWind.retrieveErrMsg("nullValue.InputFileNameIsNull");
            WorldWind.logger().log(Level.FINE, string3);
            throw new IllegalArgumentException(string3);
        }
        return string.substring(0, string.lastIndexOf(".")) + (string2 != null ? string2 : "");
    }

    public static File saveBufferToTempFile(ByteBuffer byteBuffer, String string) throws IOException {
        if (byteBuffer == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.ByteBufferIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        File file = File.createTempFile("WorldWind", string != null ? string : "");
        file.deleteOnExit();
        byteBuffer.rewind();
        WWIO.saveBuffer(byteBuffer, file);
        return file;
    }

    public static String getSuffixForMimeType(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.MimeTypeIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.equalsIgnoreCase("image/jpeg") || string.equalsIgnoreCase("image/jpg")) {
            return ".jpg";
        }
        if (string.equalsIgnoreCase("image/png")) {
            return ".png";
        }
        return null;
    }

    public static boolean isFileOutOfDate(URL uRL, long l) {
        if (uRL == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.URLIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        try {
            URI uRI = uRL.toURI();
            if (uRI.isOpaque()) {
                return false;
            }
            File file = new File(uRI);
            return file.exists() && file.lastModified() < l;
        }
        catch (URISyntaxException uRISyntaxException) {
            String string = WorldWind.retrieveErrMsg("WWIO.ExceptionValidatingFileExpiration");
            WorldWind.logger().log(Level.FINE, string + uRL);
            return false;
        }
    }
}

