/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.PickedObjectList;
import gov.nasa.worldwind.RenderingEvent;
import gov.nasa.worldwind.RenderingListener;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindowImpl;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.swing.event.EventListenerList;

public class WorldWindowGLAutoDrawable
extends WorldWindowImpl
implements GLEventListener {
    private final GLAutoDrawable drawable;
    private final EventListenerList eventListeners = new EventListenerList();
    private Point pickPoint;

    public WorldWindowGLAutoDrawable(GLAutoDrawable gLAutoDrawable) {
        if (gLAutoDrawable == null) {
            String string = WorldWind.retrieveErrMsg("WorldWindowGLCanvas.GLAutoDrawableNullToConstructor");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.drawable = gLAutoDrawable;
        this.drawable.setAutoSwapBufferMode(false);
        gLAutoDrawable.addGLEventListener(this);
        SceneController sceneController = this.getSceneController();
        if (sceneController != null) {
            sceneController.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PropertyChangeEventIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.drawable.repaint();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(GLAutoDrawable gLAutoDrawable) {
        try {
            SceneController sceneController = this.getSceneController();
            if (sceneController == null) {
                String string = WorldWind.retrieveErrMsg("WorldWindowGLCanvas.ScnCntrllerNullOnRepaint");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalStateException(string);
            }
            if (this.pickPoint != null) {
                sceneController.pick(this.pickPoint);
                this.pickPoint = null;
            }
            try {
                this.callRenderingListeners(new RenderingEvent(this.drawable, "gov.nasa.worldwind.RenderingEvent.BeginStage"));
            }
            catch (Exception exception) {
                WorldWind.logger().log(Level.FINE, WorldWind.retrieveErrMsg("WorldWindowGLAutoDrawable.ExceptionDuringGLEventListenerDisplay"), exception);
            }
            sceneController.repaint();
            try {
                this.callRenderingListeners(new RenderingEvent(this.drawable, "gov.nasa.worldwind.RenderingEvent.EndStage"));
            }
            catch (Exception exception) {
                WorldWind.logger().log(Level.FINE, WorldWind.retrieveErrMsg("WorldWindowGLAutoDrawable.ExceptionDuringGLEventListenerDisplay"), exception);
            }
            this.drawable.swapBuffers();
        }
        catch (Exception exception) {
            WorldWind.logger().log(Level.FINE, WorldWind.retrieveErrMsg("WorldWindowGLCanvas.ExceptionAttemptingRepaintWorldWindow"), exception);
        }
        finally {
            this.pickPoint = null;
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        WorldWind.logger().log(Level.FINEST, WorldWind.retrieveErrMsg("WorldWindowGLCanvas.DisplayEventListenersDisplayChangedMethodCalled"));
    }

    public PickedObjectList pick(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PickPoint");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.pickPoint = point;
        this.drawable.display();
        return this.getSceneController().getPickedObjectList();
    }

    public void addRenderingListener(RenderingListener renderingListener) {
        this.eventListeners.add(RenderingListener.class, renderingListener);
    }

    public void removeRenderingListener(RenderingListener renderingListener) {
        this.eventListeners.remove(RenderingListener.class, renderingListener);
    }

    private void callRenderingListeners(RenderingEvent renderingEvent) {
        for (RenderingListener renderingListener : (RenderingListener[])this.eventListeners.getListeners(RenderingListener.class)) {
            renderingListener.stageChanged(renderingEvent);
        }
    }
}

