/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Quaternion;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

class InterpolatorTimer {
    private TimerTask timerTask;
    private volatile boolean isRunning;
    private PropertyChangeListener listener;
    private double stepCoefficient;
    private double errorThreshold;
    private Object begin;
    private Object end;

    public InterpolatorTimer(final int n) {
        if (n < 0) {
            String string = WorldWind.retrieveErrMsg("awt.InterpolatorTimer.PeriodLessThanZero");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Timer timer = new Timer();
        this.timerTask = new TimerTask(){

            public void run() {
                long l = System.currentTimeMillis();
                if (l - this.scheduledExecutionTime() >= (long)(2 * n)) {
                    return;
                }
                if (InterpolatorTimer.this.listener == null) {
                    return;
                }
                InterpolatorTimer.this.updateAndNotify(InterpolatorTimer.this.listener);
            }
        };
        timer.schedule(this.timerTask, 0L, (long)n);
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    private static double error(Object object, Object object2) {
        if (object instanceof Angle) {
            return InterpolatorTimer.error((Angle)object, (Angle)object2);
        }
        if (object instanceof Double) {
            return InterpolatorTimer.error((Double)object, (Double)object2);
        }
        if (object instanceof LatLon) {
            return InterpolatorTimer.error((LatLon)object, (LatLon)object2);
        }
        if (object instanceof Point) {
            return InterpolatorTimer.error((Point)object, (Point)object2);
        }
        if (object instanceof ViewProperties) {
            return InterpolatorTimer.error((ViewProperties)object, (ViewProperties)object2);
        }
        return 0.0;
    }

    private static double error(Double d, Double d2) {
        return Math.abs(d2 - d);
    }

    private static double error(Angle angle, Angle angle2) {
        return Math.abs(angle2.getDegrees() - angle.getDegrees()) % 360.0;
    }

    private static double error(LatLon latLon, LatLon latLon2) {
        double d;
        double d2 = Math.abs(latLon2.getLatitude().getRadians() - latLon.getLatitude().getRadians()) % 1.5707963267948966;
        return d2 > (d = Math.abs(latLon2.getLongitude().getRadians() - latLon.getLongitude().getRadians()) % Math.PI) ? d2 : d;
    }

    private static double error(Point point, Point point2) {
        double d = 0.0;
        d = Math.max(d, InterpolatorTimer.error(point.x(), point2.x()));
        d = Math.max(d, InterpolatorTimer.error(point.y(), point2.y()));
        d = Math.max(d, InterpolatorTimer.error(point.z(), point2.z()));
        d = Math.max(d, InterpolatorTimer.error(point.w(), point2.w()));
        return d;
    }

    private static double error(ViewProperties viewProperties, ViewProperties viewProperties2) {
        double d = 0.0;
        if (viewProperties.latLon != null && viewProperties2.latLon != null) {
            d = Math.max(d, InterpolatorTimer.error(viewProperties.latLon, viewProperties2.latLon));
        }
        if (viewProperties.heading != null && viewProperties2.heading != null) {
            d = Math.max(d, InterpolatorTimer.error(viewProperties.heading, viewProperties2.heading));
        }
        if (viewProperties.pitch != null && viewProperties2.pitch != null) {
            d = Math.max(d, InterpolatorTimer.error(viewProperties.pitch, viewProperties2.pitch));
        }
        if (viewProperties.zoom != null && viewProperties2.zoom != null) {
            d = Math.max(d, InterpolatorTimer.error(viewProperties.zoom, viewProperties2.zoom));
        }
        return d;
    }

    private static Object mix(double d, Object object, Object object2) {
        if (object instanceof Angle) {
            return InterpolatorTimer.mix(d, (Angle)object, (Angle)object2);
        }
        if (object instanceof Double) {
            return InterpolatorTimer.mix(d, (Double)object, (Double)object2);
        }
        if (object instanceof LatLon) {
            return InterpolatorTimer.mix(d, (LatLon)object, (LatLon)object2);
        }
        if (object instanceof Point) {
            return InterpolatorTimer.mix(d, (Point)object, (Point)object2);
        }
        if (object instanceof ViewProperties) {
            return InterpolatorTimer.mix(d, (ViewProperties)object, (ViewProperties)object2);
        }
        return null;
    }

    private static Angle mix(double d, Angle angle, Angle angle2) {
        Quaternion quaternion;
        if (d < 0.0) {
            return angle;
        }
        if (d > 1.0) {
            return angle2;
        }
        Quaternion quaternion2 = Quaternion.EulerToQuaternion(angle.getRadians(), 0.0, 0.0);
        Quaternion quaternion3 = Quaternion.Slerp(quaternion2, quaternion = Quaternion.EulerToQuaternion(angle2.getRadians(), 0.0, 0.0), d);
        Point point = Quaternion.QuaternionToEuler(quaternion3);
        if (Double.isNaN(point.x())) {
            return null;
        }
        return Angle.fromRadians(point.x());
    }

    private static Double mix(double d, Double d2, Double d3) {
        if (d < 0.0) {
            return d2;
        }
        if (d > 1.0) {
            return d3;
        }
        return (1.0 - d) * d2 + d * d3;
    }

    private static LatLon mix(double d, LatLon latLon, LatLon latLon2) {
        Quaternion quaternion;
        if (d < 0.0) {
            return latLon;
        }
        if (d > 1.0) {
            return latLon2;
        }
        Quaternion quaternion2 = Quaternion.EulerToQuaternion(latLon.getLongitude().getRadians(), latLon.getLatitude().getRadians(), 0.0);
        Quaternion quaternion3 = Quaternion.Slerp(quaternion2, quaternion = Quaternion.EulerToQuaternion(latLon2.getLongitude().getRadians(), latLon2.getLatitude().getRadians(), 0.0), d);
        Point point = Quaternion.QuaternionToEuler(quaternion3);
        if (Double.isNaN(point.x()) || Double.isNaN(point.y())) {
            return null;
        }
        return LatLon.fromRadians(point.y(), point.x());
    }

    private static Point mix(double d, Point point, Point point2) {
        return new Point(InterpolatorTimer.mix(d, point.x(), point2.x()), InterpolatorTimer.mix(d, point.y(), point2.y()), InterpolatorTimer.mix(d, point.z(), point2.z()), InterpolatorTimer.mix(d, point.w(), point2.w()));
    }

    private static ViewProperties mix(double d, ViewProperties viewProperties, ViewProperties viewProperties2) {
        ViewProperties viewProperties3 = new ViewProperties();
        if (viewProperties.latLon != null && viewProperties2.latLon != null) {
            viewProperties3.latLon = InterpolatorTimer.mix(d, viewProperties.latLon, viewProperties2.latLon);
        }
        if (viewProperties.heading != null && viewProperties2.heading != null) {
            if (viewProperties.pitch != null && viewProperties2.pitch != null) {
                Quaternion quaternion;
                Quaternion quaternion2 = Quaternion.EulerToQuaternion(viewProperties.heading.getRadians(), viewProperties.pitch.getRadians(), 0.0);
                Quaternion quaternion3 = Quaternion.Slerp(quaternion2, quaternion = Quaternion.EulerToQuaternion(viewProperties2.heading.getRadians(), viewProperties2.pitch.getRadians(), 0.0), d);
                Point point = Quaternion.QuaternionToEuler(quaternion3);
                if (!Double.isNaN(point.x()) && !Double.isNaN(point.y())) {
                    viewProperties3.heading = Angle.fromRadians(point.x());
                    viewProperties3.pitch = Angle.fromRadians(point.y());
                } else {
                    viewProperties3.heading = null;
                    viewProperties3.pitch = null;
                }
            } else {
                viewProperties3.heading = InterpolatorTimer.mix(d, viewProperties.heading, viewProperties2.heading);
            }
        } else if (viewProperties.pitch != null && viewProperties2.pitch != null) {
            viewProperties3.pitch = InterpolatorTimer.mix(d, viewProperties.pitch, viewProperties2.pitch);
        }
        if (viewProperties.zoom != null && viewProperties2.zoom != null) {
            viewProperties3.zoom = InterpolatorTimer.mix(d, viewProperties.zoom, viewProperties2.zoom);
        }
        return viewProperties3;
    }

    public synchronized void start(double d, double d2, Object object, Object object2, PropertyChangeListener propertyChangeListener) {
        if (d < 0.0) {
            String string = WorldWind.retrieveErrMsg("awt.InterpolatorTimer.StepCoefficientLessThanZero");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = WorldWind.retrieveErrMsg("awt.InterpolatorTimer.ErrorThresholdLessThanZero");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (object == null || object2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ObjectIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!object2.getClass().isInstance(object)) {
            String string = WorldWind.retrieveErrMsg("awt.InterpolatorTimer.DifferentMixTypes");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (propertyChangeListener == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ListenerIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.isRunning && this.listener != null && !this.listener.equals(propertyChangeListener)) {
            this.listener.propertyChange(new PropertyChangeEvent(this, null, null, null));
        }
        this.listener = propertyChangeListener;
        this.stepCoefficient = d;
        this.errorThreshold = d2;
        this.begin = object;
        this.end = object2;
        this.isRunning = true;
    }

    public synchronized void stop() {
        if (this.isRunning) {
            if (this.listener != null) {
                this.listener.propertyChange(new PropertyChangeEvent(this, null, null, null));
            }
            this.listener = null;
            this.errorThreshold = -1.0;
            this.stepCoefficient = -1.0;
            this.end = null;
            this.begin = null;
            this.isRunning = false;
        }
    }

    private synchronized void updateAndNotify(PropertyChangeListener propertyChangeListener) {
        if (!this.isRunning || this.begin == null || propertyChangeListener == null) {
            return;
        }
        Object object = InterpolatorTimer.mix(this.stepCoefficient, this.begin, this.end);
        if (object == null) {
            this.stop();
            return;
        }
        double d = InterpolatorTimer.error(object, this.end);
        if (d < this.errorThreshold) {
            this.stop();
            return;
        }
        propertyChangeListener.propertyChange(new PropertyChangeEvent(this, null, this.begin, object));
        this.begin = object;
    }

    static class ViewProperties {
        public LatLon latLon;
        public Angle heading;
        public Angle pitch;
        public Double zoom;

        ViewProperties() {
        }
    }
}

