/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.DDSConverter;
import gov.nasa.worldwind.formats.nitfs.AbstractRpf2DdsCompress;
import gov.nasa.worldwind.formats.nitfs.DDSBlock4x4;
import gov.nasa.worldwind.formats.nitfs.NitfsImageBand;

class Cadrg2DdsCompress
extends AbstractRpf2DdsCompress {
    Cadrg2DdsCompress() {
    }

    public DDSBlock4x4 compressDxt1Block4x4(NitfsImageBand nitfsImageBand, byte[] byArray, boolean bl) {
        int[] nArray = new int[16];
        DDSConverter.Color[] colorArray = new DDSConverter.Color[16];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = nitfsImageBand.lookupR5G6B5(0xFF & byArray[i]);
            colorArray[i] = DDSConverter.getColor565(nArray[i]);
        }
        int[] nArray2 = Cadrg2DdsCompress.determineExtremeColors(colorArray);
        if (nArray[nArray2[0]] < nArray[nArray2[1]]) {
            int n = nArray2[0];
            nArray2[0] = nArray2[1];
            nArray2[1] = n;
        }
        return new DDSBlock4x4((short)nArray[nArray2[0]], (short)nArray[nArray2[1]], (int)DDSConverter.computeBitMask(colorArray, nArray2));
    }
}

