/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.DDSConverter;
import gov.nasa.worldwind.formats.nitfs.AbstractRpf2DdsCompress;
import gov.nasa.worldwind.formats.nitfs.DDSBlock4x4;
import gov.nasa.worldwind.formats.nitfs.NitfsImageBand;

class Cib2DdsCompress
extends AbstractRpf2DdsCompress {
    Cib2DdsCompress() {
    }

    public DDSBlock4x4 compressDxt1Block4x4(NitfsImageBand nitfsImageBand, byte[] byArray, boolean bl) {
        int[] nArray = new int[16];
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = nitfsImageBand.lookupGray(0xFF & byArray[i]);
            if (nArray[i] < n) {
                n = nArray[i];
            }
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
        }
        DDSBlock4x4 dDSBlock4x4 = new DDSBlock4x4((short)DDSConverter.getPixel565(new DDSConverter.Color(n2, n2, n2)), (short)DDSConverter.getPixel565(new DDSConverter.Color(n, n, n)), 0);
        if (n2 != n) {
            int[] nArray2 = new int[]{n2, n, (2 * n2 + n) / 3, (n2 + 2 * n) / 3};
            dDSBlock4x4.bitmask = 0;
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = Integer.MAX_VALUE;
                int n4 = 0;
                for (int j = 0; j < nArray2.length; ++j) {
                    int n5;
                    int n6 = n5 = nArray2[j] >= nArray[i] ? nArray2[j] - nArray[i] : nArray[i] - nArray2[j];
                    if (n5 >= n3) continue;
                    n3 = n5;
                    n4 = j;
                }
                dDSBlock4x4.bitmask |= n4 << i * 2;
            }
        }
        return dDSBlock4x4;
    }
}

