/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsUtil;
import gov.nasa.worldwind.formats.rpf.RpfColorMap;
import java.nio.ByteBuffer;

class CompressionLookupRecord {
    private int tableID;
    private int numOfRecords;
    private int numOfValuesPerRecord;
    private int valueBitLength;
    private int tableLocation;
    private short bytesPerRecord;
    private byte[] lut;

    public int getTableID() {
        return this.tableID;
    }

    public int getNumOfRecords() {
        return this.numOfRecords;
    }

    public int getNumOfValuesPerRecord() {
        return this.numOfValuesPerRecord;
    }

    public int getValueBitLength() {
        return this.valueBitLength;
    }

    public short getBytesPerRecord() {
        return this.bytesPerRecord;
    }

    public byte[] copyValues(byte[] byArray, int n, int n2, int n3) {
        if (n3 != this.bytesPerRecord) {
            throw new NitfsRuntimeException("NitfsReader.AttemptToCopyWithInvalidSizeOfRecord");
        }
        if (n2 >= this.numOfRecords) {
            throw new NitfsRuntimeException("NitfsReader.AttemptToCopyOutOfBoundsAtSource");
        }
        if (null == byArray) {
            throw new NitfsRuntimeException("NitfsReader.AttemptCopyToIvalidDestination");
        }
        if (byArray.length < n + n3) {
            throw new NitfsRuntimeException("NitfsReader.AttemptToCopyOutOfBoundsAtDestination");
        }
        System.arraycopy(this.lut, n2 * this.bytesPerRecord, byArray, n, this.bytesPerRecord);
        return byArray;
    }

    public CompressionLookupRecord(ByteBuffer byteBuffer, int n, RpfColorMap[] rpfColorMapArray) {
        this.tableID = NitfsUtil.getUShort(byteBuffer);
        this.numOfRecords = (int)NitfsUtil.getUInt(byteBuffer);
        this.numOfValuesPerRecord = NitfsUtil.getUShort(byteBuffer);
        this.valueBitLength = NitfsUtil.getUShort(byteBuffer);
        this.tableLocation = (int)(NitfsUtil.getUInt(byteBuffer) + (long)n);
        int n2 = byteBuffer.position();
        this.bytesPerRecord = (short)((long)(this.numOfValuesPerRecord * this.valueBitLength) / 8L);
        this.lut = new byte[this.numOfRecords * this.bytesPerRecord];
        byteBuffer.position(this.tableLocation);
        byteBuffer.get(this.lut, 0, this.numOfRecords * this.bytesPerRecord);
        byteBuffer.position(n2);
    }
}

