/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.StringUtil;
import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsUtil;
import gov.nasa.worldwind.formats.rpf.RpfFrameFileComponents;
import java.nio.ByteBuffer;

public class UserDefinedImageSubheader {
    private RpfFrameFileComponents rpfFrameFileComponents = null;
    private short overflow;
    private String tag;
    private int dataLength;

    public short getOverflow() {
        return this.overflow;
    }

    public String getTag() {
        return this.tag;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public RpfFrameFileComponents getRpfFrameFileComponents() {
        return this.rpfFrameFileComponents;
    }

    public UserDefinedImageSubheader(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        this.overflow = NitfsUtil.getShortNumeric(byteBuffer, 3);
        this.tag = NitfsUtil.getString(byteBuffer, 6);
        this.dataLength = NitfsUtil.getShortNumeric(byteBuffer, 5);
        if (0 < this.dataLength) {
            if (StringUtil.Equals(this.tag, "RPFIMG")) {
                this.rpfFrameFileComponents = new RpfFrameFileComponents(byteBuffer);
            } else {
                throw new NitfsRuntimeException("NitfsReader.UnknownOrUnsupportedUserDefinedImageSubheader");
            }
        }
    }
}

