/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsUtil;
import java.nio.ByteBuffer;

public class RpfColorMap {
    private byte[] colorMap;
    private int tableID;
    private long numOfColorRecords;
    private short colorElementLength;
    private int histogramRecordLength;
    private long colorTableOffset;
    private long histogramTableOffset;

    public int getTableID() {
        return this.tableID;
    }

    public int getHistogramRecordLength() {
        return this.histogramRecordLength;
    }

    public int getHistogramTableOffset() {
        return (int)(0xFFFFFFFFL & this.histogramTableOffset);
    }

    public int getNumOfColorRecords() {
        return (int)(0xFFFFFFFFL & this.numOfColorRecords);
    }

    public int getColorElementLength() {
        return (int)(0xFFFFFFFFL & (long)this.colorElementLength);
    }

    public byte getColor(int n, int n2) {
        long l = n * this.getNumOfColorRecords() * this.getColorElementLength() + n2;
        return this.colorMap[(int)l];
    }

    public byte[] getColorMap() {
        return this.colorMap;
    }

    public RpfColorMap(ByteBuffer byteBuffer, int n) {
        this.parseRpfColorOffsetRecord(byteBuffer);
        int n2 = byteBuffer.position();
        this.loadColorMaps(byteBuffer, n);
        byteBuffer.position(n2);
    }

    private void parseRpfColorOffsetRecord(ByteBuffer byteBuffer) {
        this.tableID = NitfsUtil.getUShort(byteBuffer);
        this.numOfColorRecords = NitfsUtil.getUInt(byteBuffer);
        this.colorElementLength = NitfsUtil.getByteAsShort(byteBuffer);
        this.histogramRecordLength = NitfsUtil.getUShort(byteBuffer);
        this.colorTableOffset = NitfsUtil.getUInt(byteBuffer);
        this.histogramTableOffset = NitfsUtil.getUInt(byteBuffer);
    }

    private void loadColorMaps(ByteBuffer byteBuffer, int n) {
        if (0L == this.numOfColorRecords) {
            throw new NitfsRuntimeException("NitfsReader.InvalidNumberOfColorRecords");
        }
        if (0 == this.colorElementLength) {
            throw new NitfsRuntimeException("NitfsReader.InvalidLengthOfColorRecordElement");
        }
        byteBuffer.position((int)((long)n + this.colorTableOffset));
        int n2 = (int)(this.numOfColorRecords * (long)this.colorElementLength);
        this.colorMap = new byte[n2];
        byteBuffer.get(this.colorMap, 0, n2);
    }

    private void loadHistogram(ByteBuffer byteBuffer, int n) {
        if (0L == this.numOfColorRecords) {
            throw new NitfsRuntimeException("NitfsReader.InvalidNumberOfColorRecords");
        }
        if (0 == this.histogramRecordLength) {
            throw new NitfsRuntimeException("NitfsReader.InvalidLengthOfHistogramRecordElement");
        }
        byteBuffer.position((int)((long)n + this.histogramTableOffset + this.numOfColorRecords * (long)this.histogramRecordLength));
    }
}

