/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsUtil;
import gov.nasa.worldwind.formats.rpf.RpfColorMap;
import gov.nasa.worldwind.formats.rpf.RpfLocationSection;
import gov.nasa.worldwind.geom.LatLon;
import java.nio.ByteBuffer;

public class RpfFrameFileComponents {
    public static final String DATA_TAG = "RPFIMG";
    public RpfLocationSection componentLocationTable;
    public LatLon nwUpperLeft;
    public LatLon swLowerleft;
    public LatLon neUpperRight;
    public LatLon seLowerRight;
    public double verticalResolutionNorthSouth;
    public double horizontalResolutionEastWest;
    public double verticalIntervalLatitude;
    public double horizontalIntervalLongitude;
    public RpfColorMap[] rpfColorMaps;
    public short numOfColorGrayscaleOffsetRecords;
    public short numOfColorConverterOffsetRecords;
    public String externalColorGrayscaleFilename;
    public long colormapOffsetTableOffset;
    public int colormapGrayscaleOffsetRecordLength;
    public int numOfSpectralGroups;
    public int numOfSubframeTables;
    public int numOfSpectralBandTables;
    public int numOfSpectralBandLinesPerImageRow;
    public int numOfSubframesInEastWestDirection;
    public int numOfSubframesInNorthSouthDirection;
    public long numOfOutputColumnsPerSubframe;
    public long numOfOutputRowsPerSubframe;
    public long subframeMaskTableOffset;
    public long transparencyMaskTableOffset;
    public RelatedImagesSection relatedImagesSection = null;

    public RpfFrameFileComponents(ByteBuffer byteBuffer) {
        this.componentLocationTable = new RpfLocationSection(byteBuffer);
        if (0 < this.componentLocationTable.getCoverageSectionSubheaderLength()) {
            this.parseRpfCoverageSection(byteBuffer);
        }
        if (0 < this.componentLocationTable.getColorGrayscaleSectionSubheaderLength()) {
            this.parseColorGrayscaleSection(byteBuffer);
        }
        if (0 < this.componentLocationTable.getColormapSubsectionLength()) {
            this.parseColormapSubSection(byteBuffer);
        }
        if (0 < this.componentLocationTable.getColorConverterSubsectionLength()) {
            this.parseColorConverterSubsection(byteBuffer);
        }
        if (0 < this.componentLocationTable.getImageDescriptionSubheaderLength()) {
            byteBuffer.position(this.componentLocationTable.getImageDescriptionSubheaderLocation());
            this.parseImageDescriptionSubheader(byteBuffer);
        }
        if (0 < this.componentLocationTable.getRelatedImagesSectionSubheaderLength()) {
            byteBuffer.position(this.componentLocationTable.getRelatedImagesSectionSubheaderLocation());
            this.relatedImagesSection = new RelatedImagesSection(byteBuffer);
        }
    }

    private void parseImageDescriptionSubheader(ByteBuffer byteBuffer) {
        this.numOfSpectralGroups = NitfsUtil.getUShort(byteBuffer);
        this.numOfSubframeTables = NitfsUtil.getUShort(byteBuffer);
        this.numOfSpectralBandTables = NitfsUtil.getUShort(byteBuffer);
        this.numOfSpectralBandLinesPerImageRow = NitfsUtil.getUShort(byteBuffer);
        this.numOfSubframesInEastWestDirection = NitfsUtil.getUShort(byteBuffer);
        this.numOfSubframesInNorthSouthDirection = NitfsUtil.getUShort(byteBuffer);
        this.numOfOutputColumnsPerSubframe = NitfsUtil.getUInt(byteBuffer);
        this.numOfOutputRowsPerSubframe = NitfsUtil.getUInt(byteBuffer);
        this.subframeMaskTableOffset = NitfsUtil.getUInt(byteBuffer);
        this.transparencyMaskTableOffset = NitfsUtil.getUInt(byteBuffer);
    }

    private void parseColorConverterSubsection(ByteBuffer byteBuffer) {
        byteBuffer.position(this.componentLocationTable.getColorConverterSubsectionLocation());
    }

    private void parseColormapSubSection(ByteBuffer byteBuffer) {
        byteBuffer.position(this.componentLocationTable.getColormapSubsectionLocation());
        this.colormapOffsetTableOffset = NitfsUtil.getUInt(byteBuffer);
        this.colormapGrayscaleOffsetRecordLength = NitfsUtil.getUShort(byteBuffer);
        if (0 < this.numOfColorGrayscaleOffsetRecords) {
            this.rpfColorMaps = new RpfColorMap[this.numOfColorGrayscaleOffsetRecords];
            for (int i = 0; i < this.numOfColorGrayscaleOffsetRecords; ++i) {
                this.rpfColorMaps[i] = new RpfColorMap(byteBuffer, this.componentLocationTable.getColormapSubsectionLocation());
            }
        } else {
            throw new NitfsRuntimeException("NitfsReader.InvalidNumberOfRpfColorGrayscaleRecords");
        }
    }

    private void parseColorGrayscaleSection(ByteBuffer byteBuffer) {
        byteBuffer.position(this.componentLocationTable.getColorGrayscaleSectionSubheaderLocation());
        this.numOfColorGrayscaleOffsetRecords = NitfsUtil.getByteAsShort(byteBuffer);
        this.numOfColorConverterOffsetRecords = NitfsUtil.getByteAsShort(byteBuffer);
        this.externalColorGrayscaleFilename = NitfsUtil.getString(byteBuffer, 12);
    }

    private void parseRpfCoverageSection(ByteBuffer byteBuffer) {
        byteBuffer.position(this.componentLocationTable.getCoverageSectionSubheaderLocation());
        this.nwUpperLeft = LatLon.fromDegrees(byteBuffer.getDouble(), byteBuffer.getDouble());
        this.swLowerleft = LatLon.fromDegrees(byteBuffer.getDouble(), byteBuffer.getDouble());
        this.neUpperRight = LatLon.fromDegrees(byteBuffer.getDouble(), byteBuffer.getDouble());
        this.seLowerRight = LatLon.fromDegrees(byteBuffer.getDouble(), byteBuffer.getDouble());
        this.verticalResolutionNorthSouth = byteBuffer.getDouble();
        this.horizontalResolutionEastWest = byteBuffer.getDouble();
        this.verticalIntervalLatitude = byteBuffer.getDouble();
        this.horizontalIntervalLongitude = byteBuffer.getDouble();
    }

    public class RelatedImagesSection {
        public long relatedImageDescriptionTableOffset;
        public int numOfRelatedImageDescriptionRecords;
        public int relatedImageDescriptionRecordLength;

        public RelatedImagesSection(ByteBuffer byteBuffer) {
            this.relatedImageDescriptionTableOffset = NitfsUtil.getUInt(byteBuffer);
            this.numOfRelatedImageDescriptionRecords = NitfsUtil.getUShort(byteBuffer);
            this.relatedImageDescriptionRecordLength = NitfsUtil.getUShort(byteBuffer);
        }
    }
}

