/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpfFrameFileIndexSection {
    private String highestSecurityClassification;
    private long frameFileIndexTableOffset;
    private long numOfFrameFileIndexRecords;
    private int numOfPathnameRecords;
    private int frameFileIndexRecordLength;
    private ArrayList<RpfFrameFileIndexRecord> frameFileIndexTable = new ArrayList();

    public String getHighestSecurityClassification() {
        return this.highestSecurityClassification;
    }

    public long getFrameFileIndexTableOffset() {
        return this.frameFileIndexTableOffset;
    }

    public long getNumOfFrameFileIndexRecords() {
        return this.numOfFrameFileIndexRecords;
    }

    public int getNumOfPathnameRecords() {
        return this.numOfPathnameRecords;
    }

    public int getFrameFileIndexRecordLength() {
        return this.frameFileIndexRecordLength;
    }

    public ArrayList<RpfFrameFileIndexRecord> getFrameFileIndexTable() {
        return this.frameFileIndexTable;
    }

    public RpfFrameFileIndexSection(ByteBuffer byteBuffer) {
        this.highestSecurityClassification = NitfsUtil.getString(byteBuffer, 1);
        this.frameFileIndexTableOffset = NitfsUtil.getUInt(byteBuffer);
        this.numOfFrameFileIndexRecords = NitfsUtil.getUInt(byteBuffer);
        this.numOfPathnameRecords = NitfsUtil.getUShort(byteBuffer);
        this.frameFileIndexRecordLength = NitfsUtil.getUShort(byteBuffer);
        this.parseFrameFileIndexAndPathnameTables(byteBuffer);
    }

    private void parseFrameFileIndexAndPathnameTables(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.position();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n3 = 0;
        while ((long)n3 < this.numOfFrameFileIndexRecords) {
            this.frameFileIndexTable.add(new RpfFrameFileIndexRecord(byteBuffer));
            ++n3;
        }
        for (n3 = 0; n3 < this.numOfPathnameRecords; ++n3) {
            int n4 = byteBuffer.position() - n2;
            n = NitfsUtil.getUShort(byteBuffer);
            hashtable.put(n4, NitfsUtil.getString(byteBuffer, n));
        }
        if (0 < this.frameFileIndexTable.size() && 0 < hashtable.size()) {
            for (RpfFrameFileIndexRecord rpfFrameFileIndexRecord : this.frameFileIndexTable) {
                n = (int)rpfFrameFileIndexRecord.getPathnameRecordOffset();
                if (hashtable.containsKey(n)) {
                    rpfFrameFileIndexRecord.setPathname((String)hashtable.get(n));
                    continue;
                }
                throw new NitfsRuntimeException("NitfsReader.CorrespondingPathnameWasNotFound");
            }
        }
    }

    public class RpfFrameFileIndexRecord {
        private int boundaryRectangleRecordNumber;
        private int frameLocationRowNumber;
        private int frameLocationColumnNumber;
        private long pathnameRecordOffset;
        private String frameFileName;
        private String geoLocation;
        private String securityClass;
        private String securityCountryCode;
        private String securityReleaseMark;
        private String pathname;

        public int getBoundaryRectangleRecordNumber() {
            return this.boundaryRectangleRecordNumber;
        }

        public int getFrameLocationRowNumber() {
            return this.frameLocationRowNumber;
        }

        public int getFrameLocationColumnNumber() {
            return this.frameLocationColumnNumber;
        }

        public String getFrameFileName() {
            return this.frameFileName;
        }

        public String getGeoLocation() {
            return this.geoLocation;
        }

        public String getSecurityClass() {
            return this.securityClass;
        }

        public String getSecurityCountryCode() {
            return this.securityCountryCode;
        }

        public String getSecurityReleaseMark() {
            return this.securityReleaseMark;
        }

        public long getPathnameRecordOffset() {
            return this.pathnameRecordOffset;
        }

        public String getPathname() {
            return this.pathname;
        }

        public void setPathname(String string) {
            this.pathname = string;
        }

        public RpfFrameFileIndexRecord(ByteBuffer byteBuffer) {
            this.boundaryRectangleRecordNumber = NitfsUtil.getUShort(byteBuffer);
            this.frameLocationRowNumber = NitfsUtil.getUShort(byteBuffer);
            this.frameLocationColumnNumber = NitfsUtil.getUShort(byteBuffer);
            this.pathnameRecordOffset = NitfsUtil.getUInt(byteBuffer);
            this.frameFileName = NitfsUtil.getString(byteBuffer, 12);
            this.geoLocation = NitfsUtil.getString(byteBuffer, 6);
            this.securityClass = NitfsUtil.getString(byteBuffer, 1);
            this.securityCountryCode = NitfsUtil.getString(byteBuffer, 2);
            this.securityReleaseMark = NitfsUtil.getString(byteBuffer, 2);
            this.pathname = "";
        }
    }
}

