/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RpfDataSeries;
import gov.nasa.worldwind.formats.rpf.RpfProducer;
import gov.nasa.worldwind.formats.rpf.RpfZone;

public class RpfFrameProperties {
    public final RpfZone zone;
    public final int frameNumber;
    public final RpfDataSeries dataSeries;
    public final RpfProducer producer;
    public final int version;

    public RpfFrameProperties(RpfZone rpfZone, int n, RpfDataSeries rpfDataSeries, RpfProducer rpfProducer, int n2) {
        this.zone = rpfZone;
        this.frameNumber = n;
        this.dataSeries = rpfDataSeries;
        this.producer = rpfProducer;
        this.version = n2;
    }

    private int computeHash() {
        int n = 0;
        if (this.zone != null) {
            n = 29 * n + this.zone.hashCode();
        }
        if (this.dataSeries != null) {
            n = 29 * n + this.dataSeries.hashCode();
        }
        if (this.producer != null) {
            n = 29 * n + this.producer.hashCode();
        }
        n = 29 * n + this.version;
        n = 29 * n + this.frameNumber;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        RpfFrameProperties rpfFrameProperties = (RpfFrameProperties)object;
        if (this.zone != rpfFrameProperties.zone) {
            return false;
        }
        if (this.frameNumber != rpfFrameProperties.frameNumber) {
            return false;
        }
        if (this.dataSeries != rpfFrameProperties.dataSeries) {
            return false;
        }
        if (this.producer != rpfFrameProperties.producer) {
            return false;
        }
        return this.version == rpfFrameProperties.version;
    }

    public int hashCode() {
        return this.computeHash();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('[');
        stringBuilder.append("zone=").append((Object)this.zone);
        stringBuilder.append(", frameNumber=").append(this.frameNumber);
        stringBuilder.append(", dataSeries=").append((Object)this.dataSeries);
        stringBuilder.append(", producer=").append((Object)this.producer);
        stringBuilder.append(", version=").append(this.version);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

