/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsUtil;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class RpfLocationSection {
    private Hashtable<Integer, ComponentLocationRecord> table = new Hashtable();
    public int locationSectionLength;
    public long componentLocationTableOffset;
    public int numOfComponentLocationRecords;
    public int componentLocationRecordLength;
    public long componentAggregateLength;

    public int getHeaderComponentLocation() {
        return this.getLocation(128);
    }

    public int getHeaderComponentLength() {
        return this.getLength(128);
    }

    public int getLocationComponentLocation() {
        return this.getLocation(129);
    }

    public int getLocationComponentLength() {
        return this.getLength(129);
    }

    public int getCoverageSectionSubheaderLocation() {
        return this.getLocation(130);
    }

    public int getCoverageSectionSubheaderLength() {
        return this.getLength(130);
    }

    public int getCompressionSectionSubheaderLocation() {
        return this.getLocation(131);
    }

    public int getCompressionSectionSubheaderLength() {
        return this.getLength(131);
    }

    public int getCompressionLookupSubsectionLocation() {
        return this.getLocation(132);
    }

    public int getCompressionLookupSubsectionLength() {
        return this.getLength(132);
    }

    public int getCompressionParameterSubsectionLocation() {
        return this.getLocation(133);
    }

    public int getCompressionParameterSubsectionLength() {
        return this.getLength(133);
    }

    public int getColorGrayscaleSectionSubheaderLocation() {
        return this.getLocation(134);
    }

    public int getColorGrayscaleSectionSubheaderLength() {
        return this.getLength(134);
    }

    public int getColormapSubsectionLocation() {
        return this.getLocation(135);
    }

    public int getColormapSubsectionLength() {
        return this.getLength(135);
    }

    public int getImageDescriptionSubheaderLocation() {
        return this.getLocation(136);
    }

    public int getImageDescriptionSubheaderLength() {
        return this.getLength(136);
    }

    public int getImageDisplayParametersSubheaderLocation() {
        return this.getLocation(137);
    }

    public int getImageDisplayParametersSubheaderLength() {
        return this.getLength(137);
    }

    public int getMaskSubsectionLocation() {
        return this.getLocation(138);
    }

    public int getMaskSubsectionLength() {
        return this.getLength(138);
    }

    public int getColorConverterSubsectionLocation() {
        return this.getLocation(139);
    }

    public int getColorConverterSubsectionLength() {
        return this.getLength(139);
    }

    public int getSpatialDataSubsectionLocation() {
        return this.getLocation(140);
    }

    public int getSpatialDataSubsectionLength() {
        return this.getLength(140);
    }

    public int getAttributeSectionSubheaderLocation() {
        return this.getLocation(141);
    }

    public int getAttributeSectionSubheaderLength() {
        return this.getLength(141);
    }

    public int getAttributeSubsectionLocation() {
        return this.getLocation(142);
    }

    public int getAttributeSubsectionLength() {
        return this.getLength(142);
    }

    public int getExplicitArealCoverageTableLocation() {
        return this.getLocation(143);
    }

    public int getExplicitArealCoverageTableLength() {
        return this.getLength(143);
    }

    public int getRelatedImagesSectionSubheaderLocation() {
        return this.getLocation(144);
    }

    public int getRelatedImagesSectionSubheaderLength() {
        return this.getLength(144);
    }

    public int getRelatedImagesSubsectionLocation() {
        return this.getLocation(145);
    }

    public int getRelatedImagesSubsectionLength() {
        return this.getLength(145);
    }

    public int getReplaceUpdateSectionSubheaderLocation() {
        return this.getLocation(146);
    }

    public int getReplaceUpdateSectionSubheaderLength() {
        return this.getLength(146);
    }

    public int getReplaceUpdateTableLocation() {
        return this.getLocation(147);
    }

    public int getReplaceUpdateTableLength() {
        return this.getLength(147);
    }

    public int getBoundaryRectangleSectionSubheaderLocation() {
        return this.getLocation(148);
    }

    public int getBoundaryRectangleSectionSubheaderLength() {
        return this.getLength(148);
    }

    public int getBoundaryRectangleTableLocation() {
        return this.getLocation(149);
    }

    public int getBoundaryRectangleTableLength() {
        return this.getLength(149);
    }

    public int getFrameFileIndexSectionSubheaderLocation() {
        return this.getLocation(150);
    }

    public int getFrameFileIndexSectionSubheaderLength() {
        return this.getLength(150);
    }

    public int getFrameFileIndexSubsectionLocation() {
        return this.getLocation(151);
    }

    public int getFrameFileIndexSubsectionLength() {
        return this.getLength(151);
    }

    public int getColorTableIndexSectionSubheaderLocation() {
        return this.getLocation(152);
    }

    public int getColorTableIndexSectionSubheaderLength() {
        return this.getLength(152);
    }

    public int getColorTableIndexRecordLocation() {
        return this.getLocation(153);
    }

    public int getColorTableIndexRecordLength() {
        return this.getLength(153);
    }

    public RpfLocationSection(ByteBuffer byteBuffer) {
        this.locationSectionLength = NitfsUtil.getUShort(byteBuffer);
        this.componentLocationTableOffset = NitfsUtil.getUInt(byteBuffer);
        this.numOfComponentLocationRecords = NitfsUtil.getUShort(byteBuffer);
        this.componentLocationRecordLength = NitfsUtil.getUShort(byteBuffer);
        this.componentAggregateLength = NitfsUtil.getUInt(byteBuffer);
        if (this.numOfComponentLocationRecords < 2) {
            throw new NitfsRuntimeException("NitfsReader:InvalidNumberOfComponentLocationRecords");
        }
        for (int i = 0; i < this.numOfComponentLocationRecords; ++i) {
            int n = NitfsUtil.getUShort(byteBuffer);
            this.table.put(n, new ComponentLocationRecord(n, NitfsUtil.getUInt(byteBuffer), NitfsUtil.getUInt(byteBuffer)));
        }
    }

    private int getLocation(int n) {
        ComponentLocationRecord componentLocationRecord = this.getRecord(n);
        return (int)(null != componentLocationRecord ? 0xFFFFFFFFL & componentLocationRecord.getLocation() : 0L);
    }

    private int getLength(int n) {
        ComponentLocationRecord componentLocationRecord = this.getRecord(n);
        return (int)(null != componentLocationRecord ? 0xFFFFFFFFL & componentLocationRecord.getLength() : 0L);
    }

    private ComponentLocationRecord getRecord(int n) {
        if (this.table.containsKey(n)) {
            return this.table.get(n);
        }
        return null;
    }

    public class ComponentLocationRecord {
        private int id;
        private long length;
        private long location;

        public int getId() {
            return this.id;
        }

        public long getLength() {
            return this.length;
        }

        public long getLocation() {
            return this.location;
        }

        public ComponentLocationRecord(int n, long l, long l2) {
            this.id = n;
            this.length = l;
            this.location = l2;
        }
    }
}

