/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Angle
implements Comparable<Angle> {
    public static final Angle ZERO = Angle.fromDegrees(0.0);
    public static final Angle POS90 = Angle.fromDegrees(90.0);
    public static final Angle NEG90 = Angle.fromDegrees(-90.0);
    public static final Angle POS180 = Angle.fromDegrees(180.0);
    public static final Angle NEG180 = Angle.fromDegrees(-180.0);
    public static final Angle POS360 = Angle.fromDegrees(360.0);
    private static final double DEGREES_TO_RADIANS = Math.PI / 180;
    private static final double RADIANS_TO_DEGREES = 57.29577951308232;
    private static final double PIOver2 = 1.5707963267948966;
    public final double degrees;
    public final double radians;

    public static Angle fromDegrees(double d) {
        return new Angle(d, Math.PI / 180 * d);
    }

    public static Angle fromRadians(double d) {
        return new Angle(57.29577951308232 * d, d);
    }

    public static Angle fromDegreesLatitude(double d) {
        d = d < -90.0 ? -90.0 : (d > 90.0 ? 90.0 : d);
        double d2 = Math.PI / 180 * d;
        d2 = d2 < -1.5707963267948966 ? -1.5707963267948966 : (d2 > 1.5707963267948966 ? 1.5707963267948966 : d2);
        return new Angle(d, d2);
    }

    public static Angle fromRadiansLatitude(double d) {
        d = d < -1.5707963267948966 ? -1.5707963267948966 : (d > 1.5707963267948966 ? 1.5707963267948966 : d);
        double d2 = 57.29577951308232 * d;
        d2 = d2 < -90.0 ? -90.0 : (d2 > 90.0 ? 90.0 : d2);
        return new Angle(d2, d);
    }

    public static Angle fromDegreesLongitude(double d) {
        d = d < -180.0 ? -180.0 : (d > 180.0 ? 180.0 : d);
        double d2 = Math.PI / 180 * d;
        d2 = d2 < -Math.PI ? -Math.PI : (d2 > Math.PI ? Math.PI : d2);
        return new Angle(d, d2);
    }

    public static Angle fromRadiansLongitude(double d) {
        d = d < -Math.PI ? -Math.PI : (d > Math.PI ? Math.PI : d);
        double d2 = 57.29577951308232 * d;
        d2 = d2 < -180.0 ? -180.0 : (d2 > 180.0 ? 180.0 : d2);
        return new Angle(d2, d);
    }

    public static Angle fromXY(double d, double d2) {
        double d3 = Math.atan2(d2, d);
        return new Angle(57.29577951308232 * d3, d3);
    }

    public Angle(Angle angle) {
        this.degrees = angle.degrees;
        this.radians = angle.radians;
    }

    private Angle(double d, double d2) {
        this.degrees = d;
        this.radians = d2;
    }

    public final double getDegrees() {
        return this.degrees;
    }

    public final double getRadians() {
        return this.radians;
    }

    public final Angle add(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(this.degrees + angle.degrees);
    }

    public final Angle subtract(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(this.degrees - angle.degrees);
    }

    public final Angle multiply(double d) {
        return Angle.fromDegrees(this.degrees * d);
    }

    public final double divide(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.degrees / angle.degrees;
    }

    public final Angle addDegrees(double d) {
        return Angle.fromDegrees(this.degrees + d);
    }

    public final Angle subtractDegrees(double d) {
        return Angle.fromDegrees(this.degrees - d);
    }

    public final Angle divide(double d) {
        return Angle.fromDegrees(this.degrees / d);
    }

    public final Angle addRadians(double d) {
        return Angle.fromRadians(this.radians + d);
    }

    public final Angle subtractRadians(double d) {
        return Angle.fromRadians(this.radians - d);
    }

    public final double sin() {
        return Math.sin(this.radians);
    }

    public final double sinHalfAngle() {
        return Math.sin(0.5 * this.radians);
    }

    public static Angle asin(double d) {
        return Angle.fromRadians(Math.asin(d));
    }

    public final double cos() {
        return Math.cos(this.radians);
    }

    public final double cosHalfAngle() {
        return Math.cos(0.5 * this.radians);
    }

    public static Angle acos(double d) {
        return Angle.fromRadians(Math.acos(d));
    }

    public final double tanHalfAngle() {
        return Math.tan(0.5 * this.radians);
    }

    public static Angle atan(double d) {
        return Angle.fromRadians(Math.atan(d));
    }

    public static Angle midAngle(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(0.5 * (angle.degrees + angle2.degrees));
    }

    public static Angle average(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(0.5 * (angle.degrees + angle2.degrees));
    }

    public static Angle average(Angle angle, Angle angle2, Angle angle3) {
        if (angle == null || angle2 == null || angle3 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees((angle.degrees + angle2.degrees + angle3.degrees) / 3.0);
    }

    @Override
    public final int compareTo(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.degrees < angle.degrees) {
            return -1;
        }
        if (this.degrees > angle.degrees) {
            return 1;
        }
        return 0;
    }

    public final String toString() {
        return Double.toString(this.degrees) + '\u00b0';
    }

    public long getSizeInBytes() {
        return 64L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Angle angle = (Angle)object;
        return angle.degrees == this.degrees;
    }

    public int hashCode() {
        long l = this.degrees != 0.0 ? Double.doubleToLongBits(this.degrees) : 0L;
        return (int)(l ^ l >>> 32);
    }
}

