/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Renderable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.PolarPoint;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLUquadric;

public class Cylinder
implements Extent,
Renderable {
    private final Point bottomCenter;
    private final Point topCenter;
    private final Point axisUnitDirection;
    private final double cylinderRadius;
    private final double cylinderHeight;

    public Cylinder(Point point, Point point2, double d) {
        if (point == null || point2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.EndPointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = WorldWind.retrieveErrMsg("geom.Cylinder.RadiusIsZeroOrNegative");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.bottomCenter = point;
        this.topCenter = point2;
        this.cylinderHeight = this.bottomCenter.distanceTo(this.topCenter);
        this.cylinderRadius = d;
        this.axisUnitDirection = this.topCenter.subtract(this.bottomCenter).normalize();
    }

    public String toString() {
        return this.cylinderRadius + ", " + this.bottomCenter.toString() + ", " + this.topCenter.toString() + ", " + this.axisUnitDirection.toString();
    }

    public Intersection[] intersect(Line line) {
        double d;
        double d2;
        if (line == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LineIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Point point = line.getDirection();
        Point point2 = line.getOrigin();
        double d3 = point.x() * point.x() + point.y() * point.y();
        double d4 = Cylinder.discriminant(d3, d2 = 2.0 * (point2.x() * point.x() + point2.y() * point.y()), d = point2.x() * point2.x() + point2.y() * point2.y() - this.cylinderRadius * this.cylinderRadius);
        if (d4 < 0.0) {
            return null;
        }
        double d5 = Math.sqrt(d4);
        if (d4 == 0.0) {
            Point point3 = line.getPointAt((-d2 - d5) / (2.0 * d3));
            return new Intersection[]{new Intersection(point3, true)};
        }
        Point point4 = line.getPointAt((-d2 - d5) / (2.0 * d3));
        Point point5 = line.getPointAt((-d2 + d5) / (2.0 * d3));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (point4.z() >= 0.0 && point4.z() <= this.getHeight()) {
            bl = true;
            boolean bl5 = bl3 = point4.z() == 0.0;
        }
        if (point5.z() >= 0.0 && point5.z() <= this.getHeight()) {
            bl2 = true;
            bl4 = point5.z() == 0.0;
        }
        Intersection[] intersectionArray = null;
        if (bl && bl2) {
            intersectionArray = new Intersection[]{new Intersection(point4, bl3), new Intersection(point5, bl4)};
        } else if (bl) {
            intersectionArray = new Intersection[]{new Intersection(point4, bl3)};
        } else if (bl2) {
            intersectionArray = new Intersection[]{new Intersection(point5, bl4)};
        }
        return intersectionArray;
    }

    public boolean intersects(Line line) {
        double d;
        double d2;
        if (line == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LineIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Point point = line.getDirection();
        Point point2 = line.getOrigin();
        double d3 = point.x() * point.x() + point.y() * point.y();
        double d4 = Cylinder.discriminant(d3, d2 = 2.0 * (point2.x() * point.x() + point2.y() * point.y()), d = point2.x() * point2.x() + point2.y() * point2.y() - this.cylinderRadius * this.cylinderRadius);
        return d4 >= 0.0;
    }

    private static double discriminant(double d, double d2, double d3) {
        return d2 * d2 - 4.0 * d * d3;
    }

    private double intersectsAt(Plane plane, double d, double d2) {
        boolean bl;
        double d3 = plane.dot(this.bottomCenter);
        boolean bl2 = d3 <= -d;
        Point point = d2 < 1.0 ? this.bottomCenter.add(this.topCenter.subtract(this.bottomCenter).multiply(d2)) : this.topCenter;
        double d4 = plane.dot(point);
        boolean bl3 = bl = d4 <= -d;
        if (bl2 && bl) {
            return -1.0;
        }
        if (bl2 == bl) {
            return d2;
        }
        return (d + plane.dot(this.bottomCenter)) / plane.getNormal().dot(this.bottomCenter.subtract(point));
    }

    private double getEffectiveRadius(Plane plane) {
        double d = plane.getNormal().dot(this.axisUnitDirection);
        double d2 = 1.0 - d * d;
        if (d2 <= 0.0) {
            return 0.0;
        }
        return this.cylinderRadius * Math.sqrt(d2);
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PlaneIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getEffectiveRadius(plane);
        double d2 = this.intersectsAt(plane, d, 1.0);
        return d2 >= 0.0;
    }

    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FrustumIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getEffectiveRadius(frustum.getNear());
        double d2 = this.intersectsAt(frustum.getNear(), d, 1.0);
        if (d2 < 0.0) {
            return false;
        }
        d2 = this.intersectsAt(frustum.getFar(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getLeft());
        d2 = this.intersectsAt(frustum.getLeft(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getRight());
        d2 = this.intersectsAt(frustum.getRight(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getTop());
        d2 = this.intersectsAt(frustum.getTop(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getBottom());
        d2 = this.intersectsAt(frustum.getBottom(), d, d2);
        return d2 >= 0.0;
    }

    public Point getCenter() {
        Point point = this.bottomCenter;
        Point point2 = this.topCenter;
        return new Point(0.5 * (point.x() + point2.x()), 0.5 * (point.y() + point2.y()), 0.5 * (point.z() + point2.z()));
    }

    public double getDiameter() {
        return 2.0 * this.getRadius();
    }

    public double getRadius() {
        double d = 0.5 * this.bottomCenter.distanceTo(this.topCenter);
        return Math.sqrt(d * d + this.cylinderRadius * this.cylinderRadius);
    }

    public final double getHeight() {
        return this.cylinderHeight;
    }

    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Point point = this.getCenter();
        PolarPoint polarPoint = PolarPoint.fromCartesian(point);
        GL gL = drawContext.getGL();
        gL.glPushAttrib(12288);
        gL.glBegin(1);
        gL.glVertex3d(this.bottomCenter.x(), this.bottomCenter.y(), this.bottomCenter.z());
        gL.glVertex3d(this.topCenter.x(), this.topCenter.y(), this.topCenter.z());
        gL.glEnd();
        gL.glEnable(2929);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glTranslated(this.bottomCenter.x(), this.bottomCenter.y(), this.bottomCenter.z());
        drawContext.getGL().glRotated(polarPoint.getLongitude().getDegrees(), 0.0, 1.0, 0.0);
        drawContext.getGL().glRotated(Math.abs(polarPoint.getLatitude().getDegrees()), Math.signum(polarPoint.getLatitude().getDegrees()) * -1.0, 0.0, 0.0);
        GLUquadric gLUquadric = drawContext.getGLU().gluNewQuadric();
        drawContext.getGLU().gluQuadricDrawStyle(gLUquadric, 100011);
        drawContext.getGLU().gluCylinder(gLUquadric, this.cylinderRadius, this.cylinderRadius, this.cylinderHeight, 30, 30);
        drawContext.getGLU().gluDeleteQuadric(gLUquadric);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }
}

