/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Point;
import java.util.logging.Level;

public class Frustum {
    private final Plane left;
    private final Plane right;
    private final Plane bottom;
    private final Plane top;
    private final Plane near;
    private final Plane far;

    public Frustum() {
        this.near = new Plane(0.0, 0.0, 1.0, 1.0);
        this.far = new Plane(0.0, 0.0, -1.0, 1.0);
        this.left = new Plane(1.0, 0.0, 0.0, 1.0);
        this.right = new Plane(-1.0, 0.0, 0.0, 1.0);
        this.bottom = new Plane(0.0, 1.0, 0.0, 1.0);
        this.top = new Plane(0.0, -1.0, 0.0, 1.0);
    }

    public Frustum(Plane plane, Plane plane2, Plane plane3, Plane plane4, Plane plane5, Plane plane6) {
        if (plane == null || plane2 == null || plane3 == null || plane4 == null || plane5 == null || plane6 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PlaneIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.near = plane;
        this.far = plane2;
        this.left = plane3;
        this.right = plane4;
        this.bottom = plane5;
        this.top = plane6;
    }

    public final Plane getNear() {
        return this.near;
    }

    public final Plane getFar() {
        return this.far;
    }

    public final Plane getLeft() {
        return this.left;
    }

    public final Plane getRight() {
        return this.right;
    }

    public final Plane getBottom() {
        return this.bottom;
    }

    public final Plane getTop() {
        return this.top;
    }

    public final Frustum getInverseTransformed(Matrix matrix) {
        if (matrix == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.MatrixIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix2 = matrix.getTranspose();
        Plane plane = new Plane(matrix2.transform(this.near.getVector()));
        Plane plane2 = new Plane(matrix2.transform(this.far.getVector()));
        Plane plane3 = new Plane(matrix2.transform(this.left.getVector()));
        Plane plane4 = new Plane(matrix2.transform(this.right.getVector()));
        Plane plane5 = new Plane(matrix2.transform(this.bottom.getVector()));
        Plane plane6 = new Plane(matrix2.transform(this.top.getVector()));
        return new Frustum(plane, plane2, plane3, plane4, plane5, plane6);
    }

    public final boolean intersects(Extent extent) {
        if (extent == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ExtentIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Point point = extent.getCenter();
        double d = -extent.getRadius();
        if (this.far.dot(point) <= d) {
            return false;
        }
        if (this.left.dot(point) <= d) {
            return false;
        }
        if (this.right.dot(point) <= d) {
            return false;
        }
        if (this.top.dot(point) <= d) {
            return false;
        }
        if (this.bottom.dot(point) <= d) {
            return false;
        }
        return !(this.near.dot(point) <= d);
    }

    public final boolean contains(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.far.dot(point) < 0.0) {
            return false;
        }
        if (this.left.dot(point) < 0.0) {
            return false;
        }
        if (this.right.dot(point) < 0.0) {
            return false;
        }
        if (this.top.dot(point) < 0.0) {
            return false;
        }
        if (this.bottom.dot(point) < 0.0) {
            return false;
        }
        return !(this.near.dot(point) < 0.0);
    }

    public String toString() {
        return "near: " + this.near.toString() + "... far: " + this.far.toString() + "... left: " + this.left.toString() + "... right: " + this.right.toString() + "... bottom: " + this.bottom.toString() + "... top: " + this.top.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Frustum frustum = (Frustum)object;
        if (!this.bottom.equals(frustum.bottom)) {
            return false;
        }
        if (!this.far.equals(frustum.far)) {
            return false;
        }
        if (!this.left.equals(frustum.left)) {
            return false;
        }
        if (!this.near.equals(frustum.near)) {
            return false;
        }
        if (!this.right.equals(frustum.right)) {
            return false;
        }
        return this.top.equals(frustum.top);
    }

    public int hashCode() {
        int n = this.near.hashCode();
        n = 31 * n + this.far.hashCode();
        n = 29 * n + this.left.hashCode();
        n = 23 * n + this.right.hashCode();
        n = 19 * n + this.bottom.hashCode();
        n = 17 * n + this.top.hashCode();
        return n;
    }
}

