/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Point;
import java.util.logging.Level;

public final class Intersection {
    private final Point intersectionPoint;
    private final boolean isTangent;

    public Intersection(Point point, boolean bl) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.IntersectionPointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.intersectionPoint = point;
        this.isTangent = bl;
    }

    public final Point getIntersectionPoint() {
        return this.intersectionPoint;
    }

    public final boolean isTangent() {
        return this.isTangent;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Intersection intersection = (Intersection)object;
        if (this.isTangent != intersection.isTangent) {
            return false;
        }
        return this.intersectionPoint.equals(intersection.intersectionPoint);
    }

    public int hashCode() {
        int n = this.intersectionPoint.hashCode();
        n = 29 * n + (this.isTangent ? 1 : 0);
        return n;
    }

    public String toString() {
        String string = "Intersection Point: " + this.intersectionPoint;
        String string2 = this.isTangent ? " is a tangent." : " not a tangent";
        return string + string2;
    }
}

