/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Point;
import java.util.logging.Level;

public final class Line {
    private final Point origin;
    private final Point direction;

    public Line(Point point, Point point2) {
        String string = null;
        if (point == null) {
            string = "nullValue.OriginIsNull";
        } else if (point2 == null) {
            string = "nullValue.DirectionIsNull";
        } else if (point2.length() <= 0.0) {
            string = "geom.Line.DirectionIsZeroVector";
        }
        if (string != null) {
            string = WorldWind.retrieveErrMsg(string);
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.origin = point;
        this.direction = point2;
    }

    public final Point getDirection() {
        return this.direction;
    }

    public final Point getOrigin() {
        return this.origin;
    }

    public final Point getPointAt(double d) {
        return Point.fromOriginAndDirection(d, this.direction, this.origin);
    }

    public final double selfDot() {
        return this.origin.dot(this.direction);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Line line = (Line)object;
        if (!this.direction.equals(line.direction)) {
            return false;
        }
        return line.origin.equals(this.origin);
    }

    public final int hashCode() {
        int n = this.origin.hashCode();
        n = 29 * n + this.direction.hashCode();
        return n;
    }

    public String toString() {
        return "Origin: " + this.origin + ", Direction: " + this.direction;
    }

    public final double distanceTo(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Point point2 = this.getOrigin();
        Point point3 = point2.subtract(point);
        double d = point3.dot(this.getDirection());
        double d2 = d / this.getDirection().selfDot();
        Point point4 = this.getDirection().multiply(d2);
        double d3 = point4.selfDot();
        double d4 = point3.selfDot();
        return Math.sqrt(d4 - d3);
    }
}

