/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Point;
import java.util.logging.Level;

public class Matrix4
implements Matrix {
    private double m11 = 1.0;
    private double m12;
    private double m13;
    private double m14;
    private double m21;
    private double m22 = 1.0;
    private double m23;
    private double m24;
    private double m31;
    private double m32;
    private double m33 = 1.0;
    private double m34;
    private double m41;
    private double m42;
    private double m43;
    private double m44 = 1.0;
    private boolean isOrthonormal = true;

    public Matrix4() {
    }

    public Matrix4(double[] dArray) {
        if (dArray == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.EntriesIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < 16) {
            String string = WorldWind.retrieveErrMsg("geom.Matrix4.ArrayTooShort");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.m11 = dArray[0];
        this.m21 = dArray[1];
        this.m31 = dArray[2];
        this.m41 = dArray[3];
        this.m12 = dArray[4];
        this.m22 = dArray[5];
        this.m32 = dArray[6];
        this.m42 = dArray[7];
        this.m13 = dArray[8];
        this.m23 = dArray[9];
        this.m33 = dArray[10];
        this.m43 = dArray[11];
        this.m14 = dArray[12];
        this.m24 = dArray[13];
        this.m34 = dArray[14];
        this.m44 = dArray[15];
        this.isOrthonormal = false;
    }

    public Matrix4(float[] fArray) {
        if (fArray == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.EntriesIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < 16) {
            String string = WorldWind.retrieveErrMsg("geom.Matrix4.ArrayTooShort");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.m11 = fArray[0];
        this.m21 = fArray[1];
        this.m31 = fArray[2];
        this.m41 = fArray[3];
        this.m12 = fArray[4];
        this.m22 = fArray[5];
        this.m32 = fArray[6];
        this.m42 = fArray[7];
        this.m13 = fArray[8];
        this.m23 = fArray[9];
        this.m33 = fArray[10];
        this.m43 = fArray[11];
        this.m14 = fArray[12];
        this.m24 = fArray[13];
        this.m34 = fArray[14];
        this.m44 = fArray[15];
        this.isOrthonormal = false;
    }

    public final double[] getEntries() {
        double[] dArray = new double[]{this.m11, this.m21, this.m31, this.m41, this.m12, this.m22, this.m32, this.m42, this.m13, this.m23, this.m33, this.m43, this.m14, this.m24, this.m34, this.m44};
        return dArray;
    }

    public final Matrix setToIdentity() {
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m14 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m24 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
        this.m34 = 0.0;
        this.m41 = 0.0;
        this.m42 = 0.0;
        this.m43 = 0.0;
        this.m44 = 1.0;
        this.isOrthonormal = true;
        return this;
    }

    public final boolean isOrthonormal() {
        return this.isOrthonormal;
    }

    public final Matrix rotate(Angle angle, double d, double d2, double d3) {
        double d4;
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RotationAngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d5 = d * d + d2 * d2 + d3 * d3;
        if (angle.getDegrees() == 0.0 || d5 == 0.0) {
            return this;
        }
        if (d5 != 1.0) {
            d4 = Math.sqrt(d5);
            d /= d4;
            d2 /= d4;
            d3 /= d4;
        }
        d4 = angle.cos();
        double d6 = angle.sin();
        double d7 = 1.0 - d4;
        Matrix4 matrix4 = new Matrix4();
        matrix4.m11 = d4 + d * d * d7;
        matrix4.m12 = d * d2 * d7 - d3 * d6;
        matrix4.m13 = d * d3 * d7 + d2 * d6;
        matrix4.m14 = 0.0;
        matrix4.m21 = d * d2 * d7 + d3 * d6;
        matrix4.m22 = d4 + d2 * d2 * d7;
        matrix4.m23 = d2 * d3 * d7 - d * d6;
        matrix4.m24 = 0.0;
        matrix4.m31 = d * d3 * d7 - d2 * d6;
        matrix4.m32 = d2 * d3 * d7 + d * d6;
        matrix4.m33 = d4 + d3 * d3 * d7;
        matrix4.m34 = 0.0;
        matrix4.m41 = 0.0;
        matrix4.m42 = 0.0;
        matrix4.m43 = 0.0;
        matrix4.m44 = 1.0;
        return this.multiply(matrix4);
    }

    public final Matrix rotateX(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RotationAngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cos();
        double d2 = angle.sin();
        double d3 = this.m12 * d + this.m13 * d2;
        double d4 = this.m12 * -d2 + this.m13 * d;
        double d5 = this.m22 * d + this.m23 * d2;
        double d6 = this.m22 * -d2 + this.m23 * d;
        double d7 = this.m32 * d + this.m33 * d2;
        double d8 = this.m32 * -d2 + this.m33 * d;
        double d9 = this.m42 * d + this.m43 * d2;
        double d10 = this.m42 * -d2 + this.m43 * d;
        this.m12 = d3;
        this.m13 = d4;
        this.m22 = d5;
        this.m23 = d6;
        this.m32 = d7;
        this.m33 = d8;
        this.m42 = d9;
        this.m43 = d10;
        return this;
    }

    public final Matrix rotateY(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RotationAngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cos();
        double d2 = angle.sin();
        double d3 = this.m11 * d + this.m13 * -d2;
        double d4 = this.m11 * d2 + this.m13 * d;
        double d5 = this.m21 * d + this.m23 * -d2;
        double d6 = this.m21 * d2 + this.m23 * d;
        double d7 = this.m31 * d + this.m33 * -d2;
        double d8 = this.m31 * d2 + this.m33 * d;
        double d9 = this.m41 * d + this.m43 * -d2;
        double d10 = this.m41 * d2 + this.m43 * d;
        this.m11 = d3;
        this.m13 = d4;
        this.m21 = d5;
        this.m23 = d6;
        this.m31 = d7;
        this.m33 = d8;
        this.m41 = d9;
        this.m43 = d10;
        return this;
    }

    public final Matrix rotateZ(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RotationAngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cos();
        double d2 = angle.sin();
        double d3 = this.m11 * d + this.m12 * d2;
        double d4 = this.m11 * -d2 + this.m12 * d;
        double d5 = this.m21 * d + this.m22 * d2;
        double d6 = this.m21 * -d2 + this.m22 * d;
        double d7 = this.m31 * d + this.m32 * d2;
        double d8 = this.m31 * -d2 + this.m32 * d;
        double d9 = this.m41 * d + this.m42 * d2;
        double d10 = this.m41 * -d2 + this.m42 * d;
        this.m11 = d3;
        this.m12 = d4;
        this.m21 = d5;
        this.m22 = d6;
        this.m31 = d7;
        this.m32 = d8;
        this.m41 = d9;
        this.m42 = d10;
        return this;
    }

    public Matrix translate(double d, double d2, double d3) {
        this.m14 = this.m11 * d + this.m12 * d2 + this.m13 * d3 + this.m14;
        this.m24 = this.m21 * d + this.m22 * d2 + this.m23 * d3 + this.m24;
        this.m34 = this.m31 * d + this.m32 * d2 + this.m33 * d3 + this.m34;
        this.m44 = this.m41 * d + this.m42 * d2 + this.m43 * d3 + this.m44;
        return this;
    }

    public final Matrix translate(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.translate(point.x(), point.y(), point.z());
    }

    public final Matrix add(Matrix matrix) {
        if (matrix == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.MatrixIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Matrix4 matrix4 = (Matrix4)matrix;
        this.m11 += matrix4.m11;
        this.m12 += matrix4.m12;
        this.m13 += matrix4.m13;
        this.m14 += matrix4.m14;
        this.m21 += matrix4.m21;
        this.m22 += matrix4.m22;
        this.m23 += matrix4.m23;
        this.m24 += matrix4.m24;
        this.m31 += matrix4.m31;
        this.m32 += matrix4.m32;
        this.m33 += matrix4.m33;
        this.m34 += matrix4.m34;
        this.m41 += matrix4.m41;
        this.m42 += matrix4.m42;
        this.m43 += matrix4.m43;
        this.m44 += matrix4.m44;
        this.isOrthonormal = this.isOrthonormal || matrix4.isOrthonormal;
        return this;
    }

    public final Matrix multiply(Matrix matrix) {
        if (matrix == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.MatrixIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Matrix4 matrix4 = (Matrix4)matrix;
        double d = this.m11 * matrix4.m11 + this.m12 * matrix4.m21 + this.m13 * matrix4.m31 + this.m14 * matrix4.m41;
        double d2 = this.m11 * matrix4.m12 + this.m12 * matrix4.m22 + this.m13 * matrix4.m32 + this.m14 * matrix4.m42;
        double d3 = this.m11 * matrix4.m13 + this.m12 * matrix4.m23 + this.m13 * matrix4.m33 + this.m14 * matrix4.m43;
        double d4 = this.m11 * matrix4.m14 + this.m12 * matrix4.m24 + this.m13 * matrix4.m34 + this.m14 * matrix4.m44;
        double d5 = this.m21 * matrix4.m11 + this.m22 * matrix4.m21 + this.m23 * matrix4.m31 + this.m24 * matrix4.m41;
        double d6 = this.m21 * matrix4.m12 + this.m22 * matrix4.m22 + this.m23 * matrix4.m32 + this.m24 * matrix4.m42;
        double d7 = this.m21 * matrix4.m13 + this.m22 * matrix4.m23 + this.m23 * matrix4.m33 + this.m24 * matrix4.m43;
        double d8 = this.m21 * matrix4.m14 + this.m22 * matrix4.m24 + this.m23 * matrix4.m34 + this.m24 * matrix4.m44;
        double d9 = this.m31 * matrix4.m11 + this.m32 * matrix4.m21 + this.m33 * matrix4.m31 + this.m34 * matrix4.m41;
        double d10 = this.m31 * matrix4.m12 + this.m32 * matrix4.m22 + this.m33 * matrix4.m32 + this.m34 * matrix4.m42;
        double d11 = this.m31 * matrix4.m13 + this.m32 * matrix4.m23 + this.m33 * matrix4.m33 + this.m34 * matrix4.m43;
        double d12 = this.m31 * matrix4.m14 + this.m32 * matrix4.m24 + this.m33 * matrix4.m34 + this.m34 * matrix4.m44;
        double d13 = this.m41 * matrix4.m11 + this.m42 * matrix4.m21 + this.m43 * matrix4.m31 + this.m44 * matrix4.m41;
        double d14 = this.m41 * matrix4.m12 + this.m42 * matrix4.m22 + this.m43 * matrix4.m32 + this.m44 * matrix4.m42;
        double d15 = this.m41 * matrix4.m13 + this.m42 * matrix4.m23 + this.m43 * matrix4.m33 + this.m44 * matrix4.m43;
        double d16 = this.m41 * matrix4.m14 + this.m42 * matrix4.m24 + this.m43 * matrix4.m34 + this.m44 * matrix4.m44;
        this.m11 = d;
        this.m12 = d2;
        this.m13 = d3;
        this.m14 = d4;
        this.m21 = d5;
        this.m22 = d6;
        this.m23 = d7;
        this.m24 = d8;
        this.m31 = d9;
        this.m32 = d10;
        this.m33 = d11;
        this.m34 = d12;
        this.m41 = d13;
        this.m42 = d14;
        this.m43 = d15;
        this.m44 = d16;
        this.isOrthonormal = this.isOrthonormal || matrix4.isOrthonormal;
        return this;
    }

    public final Matrix getTranspose() {
        Matrix4 matrix4 = new Matrix4();
        matrix4.m11 = this.m11;
        matrix4.m12 = this.m21;
        matrix4.m13 = this.m31;
        matrix4.m14 = this.m41;
        matrix4.m21 = this.m12;
        matrix4.m22 = this.m22;
        matrix4.m23 = this.m32;
        matrix4.m24 = this.m42;
        matrix4.m31 = this.m13;
        matrix4.m32 = this.m23;
        matrix4.m33 = this.m33;
        matrix4.m34 = this.m43;
        matrix4.m41 = this.m14;
        matrix4.m42 = this.m24;
        matrix4.m43 = this.m34;
        matrix4.m44 = this.m44;
        matrix4.isOrthonormal = this.isOrthonormal;
        return matrix4;
    }

    public final Matrix getInverse() {
        Matrix4 matrix4 = this.isOrthonormal ? this.orthonormalInverse() : this.generalInverse();
        matrix4.isOrthonormal = this.isOrthonormal;
        return matrix4;
    }

    private Matrix4 orthonormalInverse() {
        Matrix4 matrix4 = new Matrix4();
        matrix4.m11 = this.m11;
        matrix4.m12 = this.m21;
        matrix4.m13 = this.m31;
        matrix4.m21 = this.m12;
        matrix4.m22 = this.m22;
        matrix4.m23 = this.m32;
        matrix4.m31 = this.m13;
        matrix4.m32 = this.m23;
        matrix4.m33 = this.m33;
        matrix4.m14 = -(matrix4.m11 * this.m14 + matrix4.m12 * this.m24 + matrix4.m13 * this.m34);
        matrix4.m24 = -(matrix4.m21 * this.m14 + matrix4.m22 * this.m24 + matrix4.m23 * this.m34);
        matrix4.m34 = -(matrix4.m31 * this.m14 + matrix4.m32 * this.m24 + matrix4.m33 * this.m34);
        return matrix4;
    }

    private Matrix4 generalInverse() {
        double d = this.determinant();
        if (d == 0.0) {
            return null;
        }
        double d2 = 1.0 / d;
        Matrix4 matrix4 = new Matrix4();
        double d3 = this.m33 * this.m44 - this.m34 * this.m43;
        double d4 = this.m34 * this.m42 - this.m32 * this.m44;
        double d5 = this.m32 * this.m43 - this.m33 * this.m42;
        double d6 = this.m23 * this.m44 - this.m24 * this.m43;
        double d7 = this.m24 * this.m42 - this.m22 * this.m44;
        double d8 = this.m23 * this.m34 - this.m24 * this.m33;
        double d9 = this.m22 * this.m33 - this.m23 * this.m32;
        double d10 = this.m34 * this.m41 - this.m31 * this.m44;
        double d11 = this.m31 * this.m43 - this.m33 * this.m41;
        double d12 = this.m24 * this.m41 - this.m21 * this.m44;
        double d13 = this.m24 * this.m31 - this.m21 * this.m34;
        double d14 = this.m32 * this.m44 - this.m34 * this.m42;
        double d15 = this.m31 * this.m42 - this.m32 * this.m41;
        double d16 = this.m21 * this.m42 - this.m22 * this.m41;
        double d17 = this.m21 * this.m32 - this.m22 * this.m31;
        double d18 = this.m33 * this.m41 - this.m31 * this.m43;
        matrix4.m11 = d2 * this.m22 * d3 + this.m23 * d4 + this.m24 * d5;
        matrix4.m12 = -d2 * this.m12 * d3 + this.m13 * d4 + this.m14 * d5;
        matrix4.m13 = d2 * this.m12 * d6 + this.m13 * (this.m24 * this.m42 - this.m22 * this.m44) + this.m14 * d7;
        matrix4.m14 = -d2 * this.m12 * d8 + this.m13 * (this.m24 * this.m32 - this.m22 * this.m34) + this.m14 * d9;
        matrix4.m21 = -d2 * this.m21 * d3 + this.m23 * d10 + this.m24 * d11;
        matrix4.m22 = d2 * this.m11 * d3 + this.m13 * d10 + this.m14 * d11;
        matrix4.m23 = -d2 * this.m11 * d6 + this.m13 * d12 + this.m14 * (this.m21 * this.m43 - this.m23 * this.m41);
        matrix4.m24 = -d2 * this.m11 * d8 + this.m13 * d13 + this.m14 * (this.m21 * this.m33 - this.m23 * this.m31);
        matrix4.m31 = d2 * this.m21 * d14 + this.m22 * d10 + this.m24 * d15;
        matrix4.m32 = -d2 * this.m11 * d14 + this.m12 * d10 + this.m14 * d15;
        matrix4.m33 = -d2 * this.m11 * (this.m22 * this.m44 - this.m24 * this.m42) + this.m12 * d12 + this.m14 * d16;
        matrix4.m34 = d2 * this.m11 * (this.m22 * this.m34 - this.m24 * this.m32) + this.m12 * d13 + this.m14 * d17;
        matrix4.m41 = -d2 * this.m21 * d5 + this.m22 * d18 + this.m23 * d15;
        matrix4.m42 = -d2 * this.m11 * d5 + this.m12 * d18 + this.m13 * d15;
        matrix4.m43 = d2 * this.m11 * d7 + this.m12 * (this.m23 * this.m41 - this.m21 * this.m43) + this.m13 * d16;
        matrix4.m44 = -d2 * this.m11 * d9 + this.m12 * (this.m23 * this.m31 - this.m21 * this.m33) + this.m13 * d17;
        return matrix4;
    }

    public final double determinant() {
        return this.m11 * (this.m22 * this.m33 * this.m44 + this.m23 * this.m34 * this.m42 + this.m24 * this.m32 * this.m43 - this.m24 * this.m33 * this.m42 - this.m22 * this.m34 * this.m43 - this.m23 * this.m32 * this.m44) - this.m12 * (this.m21 * this.m33 * this.m44 + this.m23 * this.m34 * this.m41 + this.m24 * this.m31 * this.m43 - this.m24 * this.m33 * this.m41 - this.m21 * this.m34 * this.m43 - this.m23 * this.m31 * this.m44) + this.m13 * (this.m21 * this.m32 * this.m44 + this.m22 * this.m34 * this.m41 + this.m24 * this.m31 * this.m42 - this.m24 * this.m32 * this.m41 - this.m21 * this.m34 * this.m42 - this.m22 * this.m31 * this.m44) - this.m14 * (this.m21 * this.m32 * this.m43 + this.m22 * this.m33 * this.m41 + this.m23 * this.m31 * this.m42 - this.m23 * this.m32 * this.m41 - this.m21 * this.m33 * this.m42 - this.m22 * this.m31 * this.m43);
    }

    public final Point transform(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = this.m11 * point.x() + this.m12 * point.y() + this.m13 * point.z() + this.m14 * point.w();
        double d2 = this.m21 * point.x() + this.m22 * point.y() + this.m23 * point.z() + this.m24 * point.w();
        double d3 = this.m31 * point.x() + this.m32 * point.y() + this.m33 * point.z() + this.m34 * point.w();
        double d4 = this.m41 * point.x() + this.m42 * point.y() + this.m43 * point.z() + this.m44 * point.w();
        return new Point(d, d2, d3, d4);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Matrix4 matrix4 = (Matrix4)object;
        if (this.isOrthonormal != matrix4.isOrthonormal) {
            return false;
        }
        if (Double.compare(matrix4.m11, this.m11) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m12, this.m12) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m13, this.m13) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m14, this.m14) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m21, this.m21) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m22, this.m22) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m23, this.m23) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m24, this.m24) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m31, this.m31) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m32, this.m32) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m33, this.m33) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m34, this.m34) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m41, this.m41) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m42, this.m42) != 0) {
            return false;
        }
        if (Double.compare(matrix4.m43, this.m43) != 0) {
            return false;
        }
        return Double.compare(matrix4.m44, this.m44) == 0;
    }

    public int hashCode() {
        long l = this.m11 != 0.0 ? Double.doubleToLongBits(this.m11) : 0L;
        int n = (int)(l ^ l >>> 32);
        l = this.m12 != 0.0 ? Double.doubleToLongBits(this.m12) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m13 != 0.0 ? Double.doubleToLongBits(this.m13) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m14 != 0.0 ? Double.doubleToLongBits(this.m14) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m21 != 0.0 ? Double.doubleToLongBits(this.m21) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m22 != 0.0 ? Double.doubleToLongBits(this.m22) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m23 != 0.0 ? Double.doubleToLongBits(this.m23) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m24 != 0.0 ? Double.doubleToLongBits(this.m24) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m31 != 0.0 ? Double.doubleToLongBits(this.m31) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m32 != 0.0 ? Double.doubleToLongBits(this.m32) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m33 != 0.0 ? Double.doubleToLongBits(this.m33) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m34 != 0.0 ? Double.doubleToLongBits(this.m34) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m41 != 0.0 ? Double.doubleToLongBits(this.m41) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m42 != 0.0 ? Double.doubleToLongBits(this.m42) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m43 != 0.0 ? Double.doubleToLongBits(this.m43) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.m44 != 0.0 ? Double.doubleToLongBits(this.m44) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        n = 29 * n + (this.isOrthonormal ? 1 : 0);
        return n;
    }

    public String toString() {
        return "Matrix4 :\n[ " + this.m11 + ", " + this.m12 + ", " + this.m13 + ", " + this.m14 + ",\n " + this.m21 + ", " + this.m22 + ", " + this.m23 + ", " + this.m24 + ",\n " + this.m31 + ", " + this.m32 + ", " + this.m33 + ", " + this.m34 + ",\n " + this.m41 + ", " + this.m42 + ", " + this.m43 + ", " + this.m44 + " ]";
    }
}

