/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.Cacheable;
import gov.nasa.worldwind.WorldWind;
import java.util.logging.Level;

public class Point
implements Cacheable {
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    public static final Point ZERO = new Point(0.0, 0.0, 0.0);
    public static final Point UNIT_X = new Point(1.0, 0.0, 0.0);
    public static final Point UNIT_Y = new Point(0.0, 1.0, 0.0);
    public static final Point UNIT_Z = new Point(0.0, 0.0, 1.0);

    public Point(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public Point(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = 1.0;
    }

    public double getW() {
        return this.w;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double z() {
        return this.z;
    }

    public final double w() {
        return this.w;
    }

    public final Point add(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return new Point(this.x + point.x, this.y + point.y, this.z + point.z, 1.0);
    }

    public final Point subtract(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return new Point(this.x - point.x, this.y - point.y, this.z - point.z, 1.0);
    }

    public final Point multiply(double d) {
        return new Point(this.x * d, this.y * d, this.z * d, 1.0);
    }

    public final Point scale(double d, double d2, double d3) {
        return new Point(this.x * d, this.y * d2, this.z * d3, this.w);
    }

    public final Point normalize() {
        double d = 1.0 / this.length();
        return this.scale(d, d, d);
    }

    public final double dot(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.x * point.x + this.y * point.y + this.z * point.z;
    }

    public final double selfDot() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double dot4(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.x * point.x + this.y * point.y + this.z * point.z + this.w * this.w;
    }

    public final double length() {
        return Math.sqrt(this.selfDot());
    }

    public final double distanceTo(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = this.x - point.x;
        double d2 = this.y - point.y;
        double d3 = this.z - point.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public final double distanceToSquared(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = this.x - point.x;
        double d2 = this.y - point.y;
        double d3 = this.z - point.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public static Point midPoint(Point point, Point point2) {
        if (point == null || point2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return new Point(0.5 * (point.x + point2.x), 0.5 * (point.y + point2.y), 0.5 * (point.z + point2.z));
    }

    public static Point fromOriginAndDirection(double d, Point point, Point point2) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DirectionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (point2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.OriginIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d2 = d * point.x() + point2.x;
        double d3 = d * point.y() + point2.y;
        double d4 = d * point.z() + point2.z;
        return new Point(d2, d3, d4);
    }

    public static Point[] composeExtrema(Point[] pointArray) {
        if (pointArray == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointsArrayIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (pointArray.length == 0) {
            return new Point[]{ZERO, ZERO};
        }
        double d = pointArray[0].x;
        double d2 = pointArray[0].y;
        double d3 = pointArray[0].z;
        double d4 = d;
        double d5 = d2;
        double d6 = d3;
        for (int i = 1; i < pointArray.length; ++i) {
            double d7 = pointArray[i].x;
            if (d7 > d4) {
                d4 = d7;
            } else if (d7 < d) {
                d = d7;
            }
            double d8 = pointArray[i].y;
            if (d8 > d5) {
                d5 = d8;
            } else if (d8 < d2) {
                d2 = d8;
            }
            double d9 = pointArray[i].z;
            if (d9 > d6) {
                d6 = d9;
                continue;
            }
            if (!(d9 < d3)) continue;
            d3 = d9;
        }
        return new Point[]{new Point(d, d2, d3), new Point(d4, d5, d6)};
    }

    public Point cross(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return new Point(this.y * point.z - this.z * point.y, this.z * point.x - this.x * point.z, this.x * point.y - this.y * point.x);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Point point = (Point)object;
        if (Double.compare(point.w, this.w) != 0) {
            return false;
        }
        if (Double.compare(point.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(point.y, this.y) != 0) {
            return false;
        }
        return Double.compare(point.z, this.z) == 0;
    }

    public int hashCode() {
        long l = this.x != 0.0 ? Double.doubleToLongBits(this.x) : 0L;
        int n = (int)(l ^ l >>> 32);
        l = this.y != 0.0 ? Double.doubleToLongBits(this.y) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.z != 0.0 ? Double.doubleToLongBits(this.z) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.w != 0.0 ? Double.doubleToLongBits(this.w) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public final String toString() {
        return "(" + Double.toString(this.x) + ", " + Double.toString(this.y) + ", " + Double.toString(this.z) + ", " + Double.toString(this.w) + ")";
    }

    public final long getSizeInBytes() {
        return 256L;
    }
}

