/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Point;
import java.util.logging.Level;

public class PolarPoint {
    public static final PolarPoint ZERO = new PolarPoint(Angle.ZERO, Angle.ZERO, 0.0);
    private final Angle latitude;
    private final Angle longitude;
    private final double radius;

    public static PolarPoint fromRadians(double d, double d2, double d3) {
        return new PolarPoint(Angle.fromRadians(d), Angle.fromRadians(d2), d3);
    }

    public static PolarPoint fromDegrees(double d, double d2, double d3) {
        return new PolarPoint(Angle.fromDegrees(d), Angle.fromDegrees(d2), d3);
    }

    public static PolarPoint fromCartesian(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return PolarPoint.fromCartesian(point.x(), point.y(), point.z());
    }

    public static PolarPoint fromCartesian(double d, double d2, double d3) {
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d5 = Math.atan2(d2, Math.sqrt(d * d + d3 * d3));
        double d6 = Math.atan2(d, d3);
        return PolarPoint.fromRadians(d5, d6, d4);
    }

    public PolarPoint(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatitudeOrLongitudeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = angle;
        this.longitude = angle2;
        this.radius = d;
    }

    public final Angle getLatitude() {
        return this.latitude;
    }

    public final Angle getLongitude() {
        return this.longitude;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final Point toCartesian() {
        return PolarPoint.toCartesian(this.latitude, this.longitude, this.radius);
    }

    public static Point toCartesian(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatitudeOrLongitudeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d2 = d * angle2.sin() * angle.cos();
        double d3 = d * angle.sin();
        double d4 = d * angle2.cos() * angle.cos();
        return new Point(d2, d3, d4);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PolarPoint polarPoint = (PolarPoint)object;
        if (Double.compare(polarPoint.radius, this.radius) != 0) {
            return false;
        }
        if (!this.latitude.equals(polarPoint.latitude)) {
            return false;
        }
        return this.longitude.equals(polarPoint.longitude);
    }

    public int hashCode() {
        int n = this.latitude.hashCode();
        n = 29 * n + this.longitude.hashCode();
        long l = this.radius != 0.0 ? Double.doubleToLongBits(this.radius) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public String toString() {
        return "(lat: " + this.latitude.toString() + ", lon: " + this.longitude.toString() + ", r: " + this.radius + ")";
    }
}

