/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import java.util.logging.Level;

public class Position {
    private final Angle latitude;
    private final Angle longitude;
    private final double elevation;
    public static final Position ZERO = new Position(Angle.ZERO, Angle.ZERO, 0.0);

    public static Position fromRadians(double d, double d2, double d3) {
        return new Position(Angle.fromRadians(d), Angle.fromRadians(d2), d3);
    }

    public static Position fromDegrees(double d, double d2, double d3) {
        return new Position(Angle.fromDegrees(d), Angle.fromDegrees(d2), d3);
    }

    public Position(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatitudeOrLongitudeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = angle;
        this.longitude = angle2;
        this.elevation = d;
    }

    public final Angle getLatitude() {
        return this.latitude;
    }

    public final Angle getLongitude() {
        return this.longitude;
    }

    public final double getElevation() {
        return this.elevation;
    }
}

