/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Renderable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Point;
import java.awt.Color;
import java.nio.DoubleBuffer;
import java.util.logging.Level;
import javax.media.opengl.GL;

public class Quadrilateral
implements Renderable {
    private LatLon southwestCorner;
    private LatLon northeastCorner;
    private double elevation;
    private Point referenceCenter;
    private DoubleBuffer vertices;
    private int antiAliasHint = 4353;
    private Color color = Color.WHITE;

    public Quadrilateral(LatLon latLon, LatLon latLon2, double d) {
        if (latLon == null || latLon2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PositionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.southwestCorner = latLon;
        this.northeastCorner = latLon2;
        this.elevation = d;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ColorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    public int getAntiAliasHint() {
        return this.antiAliasHint;
    }

    public void setAntiAliasHint(int n) {
        if (n != 4352 && n != 4353 && n != 4354) {
            String string = WorldWind.retrieveErrMsg("generic.InvalidHint");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.antiAliasHint = n;
    }

    public void setCorners(LatLon latLon, LatLon latLon2) {
        this.southwestCorner = latLon;
        this.northeastCorner = latLon2;
        this.vertices = null;
    }

    public LatLon[] getCorners() {
        LatLon[] latLonArray = new LatLon[]{this.southwestCorner, this.northeastCorner};
        return latLonArray;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        this.elevation = d;
        this.vertices = null;
    }

    private void intializeGeometry(DrawContext drawContext) {
        DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(12);
        Point[] pointArray = new Point[]{drawContext.getGlobe().computePointFromPosition(this.southwestCorner.getLatitude(), this.southwestCorner.getLongitude(), this.elevation), drawContext.getGlobe().computePointFromPosition(this.southwestCorner.getLatitude(), this.northeastCorner.getLongitude(), this.elevation), drawContext.getGlobe().computePointFromPosition(this.northeastCorner.getLatitude(), this.northeastCorner.getLongitude(), this.elevation), drawContext.getGlobe().computePointFromPosition(this.northeastCorner.getLatitude(), this.southwestCorner.getLongitude(), this.elevation)};
        Point point = Point.midPoint(pointArray[0], pointArray[2]);
        for (int i = 0; i < 4; ++i) {
            doubleBuffer.put(pointArray[i].x() - point.x());
            doubleBuffer.put(pointArray[i].y() - point.y());
            doubleBuffer.put(pointArray[i].z() - point.z());
        }
        this.referenceCenter = point;
        this.vertices = doubleBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (this.vertices == null) {
            this.intializeGeometry(drawContext);
            if (this.vertices == null) {
                return;
            }
        }
        GL gL = drawContext.getGL();
        int n = 32769;
        if (!drawContext.isPickingMode()) {
            ++n;
            if (this.color.getAlpha() != 255) {
                n += 16384;
            }
        }
        gL.glPushAttrib(n);
        gL.glPushClientAttrib(2);
        drawContext.getView().pushReferenceCenter(drawContext, this.referenceCenter);
        try {
            if (!drawContext.isPickingMode()) {
                if (this.color.getAlpha() != 255) {
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                }
                drawContext.getGL().glColor4ub((byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)this.color.getAlpha());
            }
            gL.glHint(3155, this.antiAliasHint);
            gL.glEnableClientState(32884);
            gL.glVertexPointer(3, 5130, 0, this.vertices.rewind());
            gL.glDrawArrays(7, 0, 4);
        }
        finally {
            gL.glPopClientAttrib();
            gL.glPopAttrib();
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }
}

