/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Renderable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Point;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLUquadric;

public final class Sphere
implements Extent,
Renderable {
    public static final Sphere UNIT_SPHERE = new Sphere(Point.ZERO, 1.0);
    private final Point center;
    private final double radius;

    public static Sphere createBoundingSphere(Point[] pointArray) {
        if (pointArray == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointsArrayIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (pointArray.length < 1) {
            String string = WorldWind.retrieveErrMsg("geom.Sphere.NoPointsSpecified");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Point[] pointArray2 = Point.composeExtrema(pointArray);
        Point point = Point.midPoint(pointArray2[0], pointArray2[1]);
        double d = 0.5 * pointArray2[0].distanceTo(pointArray2[1]);
        return new Sphere(point, d);
    }

    public Sphere(Point point, double d) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.CenterIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = WorldWind.retrieveErrMsg("geom.Sphere.RadiusIsZeroOrNegative");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.center = point;
        this.radius = d;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final double getDiameter() {
        return 2.0 * this.radius;
    }

    public final Point getCenter() {
        return this.center;
    }

    public final Intersection[] intersect(Line line) {
        double d;
        double d2;
        if (line == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LineIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d3 = line.getDirection().selfDot();
        double d4 = Sphere.discriminant(d3, d2 = 2.0 * line.selfDot(), d = line.getOrigin().selfDot() - this.radius * this.radius);
        if (d4 < 0.0) {
            return null;
        }
        double d5 = Math.sqrt(d4);
        if (d4 == 0.0) {
            Point point = line.getPointAt((-d2 - d5) / (2.0 * d3));
            return new Intersection[]{new Intersection(point, true)};
        }
        Point point = line.getPointAt((-d2 - d5) / (2.0 * d3));
        Point point2 = line.getPointAt((-d2 + d5) / (2.0 * d3));
        return new Intersection[]{new Intersection(point, false), new Intersection(point2, false)};
    }

    private static double discriminant(double d, double d2, double d3) {
        return d2 * d2 - 4.0 * d * d3;
    }

    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FrustumIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return frustum.intersects(this);
    }

    public boolean intersects(Line line) {
        if (line == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LineIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return line.distanceTo(this.center) <= this.radius;
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PlaneIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = plane.dot(this.center);
        return d <= this.radius;
    }

    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushAttrib(270337);
        gL.glDisable(3553);
        gL.glColor3d(1.0, 1.0, 0.0);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glTranslated(this.center.x(), this.center.y(), this.center.z());
        GLUquadric gLUquadric = drawContext.getGLU().gluNewQuadric();
        drawContext.getGLU().gluQuadricDrawStyle(gLUquadric, 100011);
        drawContext.getGLU().gluSphere(gLUquadric, this.radius, 10, 10);
        gL.glPopMatrix();
        drawContext.getGLU().gluDeleteQuadric(gLUquadric);
        gL.glPopAttrib();
    }

    public String toString() {
        return "Sphere: center = " + this.center.toString() + " radius = " + Double.toString(this.radius);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Sphere sphere = (Sphere)object;
        if (Double.compare(sphere.radius, this.radius) != 0) {
            return false;
        }
        return this.center.equals(sphere.center);
    }

    public int hashCode() {
        int n = this.center.hashCode();
        long l = this.radius != 0.0 ? Double.doubleToLongBits(this.radius) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }
}

